/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.NumberParameter;
import com.arsdigita.formbuilder.AttributeMetaData;
import com.arsdigita.formbuilder.AttributeMetaDataList;
import com.arsdigita.formbuilder.FormSectionGenerator;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.formbuilder.PersistentTextField;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.SimpleQuestionnaire;
import com.arsdigita.formbuilder.parameters.PersistentParameterListener;
import com.arsdigita.formbuilder.ui.FormBuildingPage;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class QuestionPropertiesForm
extends MetaForm {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/QuestionPropertiesForm.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$formbuilder$ui$QuestionPropertiesForm == null ? (class$com$arsdigita$formbuilder$ui$QuestionPropertiesForm = QuestionPropertiesForm.class$("com.arsdigita.formbuilder.ui.QuestionPropertiesForm")) : class$com$arsdigita$formbuilder$ui$QuestionPropertiesForm).getName());
    private RequestLocal m_nOptions = new RequestLocal();
    private FormProcessListener m_propertiesProcessListener;
    private RequestLocal m_persistentWidget = new RequestLocal(){

        protected Object initialValue(PageState pageState) {
            PersistentWidget widget = null;
            if (QuestionPropertiesForm.this.isAddMode(pageState) || QuestionPropertiesForm.this.isParameterMode(pageState)) {
                String widgetClassName = FormBuildingPage.instance().getWidgetSelection(pageState);
                widget = (PersistentWidget)FormBuilderUtil.instantiateObject(widgetClassName);
            } else {
                BigDecimal widgetID = FormBuildingPage.instance().getWidgetID(pageState);
                s_log.debug((Object)("fetching widget with id " + widgetID));
                widget = (PersistentWidget)FormBuilderUtil.instantiateFactory(widgetID);
            }
            return widget;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$formbuilder$ui$QuestionPropertiesForm;

    public QuestionPropertiesForm(String name) {
        super(name);
    }

    public Form buildForm(PageState pageState) {
        Form form = new Form("add_component");
        if (this.isViewMode(pageState)) {
            return form;
        }
        Label widgetLabel = new Label(FormBuildingPage.instance().getWidgetSelectionName(pageState));
        widgetLabel.setFontWeight("b");
        form.add(widgetLabel, 65);
        FormBuilderUtil.addTextFieldToForm(form, "question_text", "Question text");
        form.add(this.getWidgetFormSection(pageState));
        form.add(this.getDataTypeFormSection(pageState));
        if (this.isOptionGroupQuestion(pageState) && this.isAddMode(pageState)) {
            form.add(this.getOptionGroupFormSection());
        }
        form.add(new Submit(FormBuildingPage.instance().getPageMode(pageState)));
        form.addInitListener(this.getInitListener());
        form.addProcessListener(this.getSingleProcessListener());
        return form;
    }

    private FormInitListener getInitListener() {
        return new FormInitListener(){

            public void init(FormSectionEvent e) {
                FormData formData = e.getFormData();
                PageState pageState = e.getPageState();
                if (FormBuildingPage.instance().getPageMode(pageState).equals("edit")) {
                    int position = FormBuildingPage.instance().getQuestionPosition(pageState);
                    SimpleQuestionnaire questionnaire = FormBuildingPage.instance().getQuestionnaire(pageState);
                    PersistentLabel label = questionnaire.getQuestionLabel(position);
                    formData.put("question_text", label.getLabel());
                }
                if (QuestionPropertiesForm.this.isEditMode(pageState) || QuestionPropertiesForm.this.isParameterMode(pageState)) {
                    formData.put("parameterName", FormBuildingPage.instance().getParameterName(pageState));
                }
            }
        };
    }

    private FormProcessListener getSingleProcessListener() {
        return new FormProcessListener(){

            public void process(FormSectionEvent formEvent) {
                PageState pageState = formEvent.getPageState();
                if (FormBuildingPage.instance().getQuestionnaire(pageState).listenerHasMetaData()) {
                    formEvent.getFormData().put("parameterName", (Object)null);
                }
                try {
                    QuestionPropertiesForm.this.m_propertiesProcessListener.process(formEvent);
                }
                catch (FormProcessException e) {
                    throw new UncheckedWrapperException((Throwable)((Object)e));
                }
                String parameterName = FormBuildingPage.instance().getParameterName(pageState);
                if (QuestionPropertiesForm.this.isParameterMode(pageState)) {
                    QuestionPropertiesForm.this.getPersistentWidget(pageState).setParameterName(parameterName);
                }
                QuestionPropertiesForm.this.processDataTypes(formEvent);
                if (QuestionPropertiesForm.this.isAddMode(pageState)) {
                    QuestionPropertiesForm.this.processQuestionnaire(formEvent);
                }
                if (QuestionPropertiesForm.this.isOptionGroupQuestion(pageState) && QuestionPropertiesForm.this.isAddMode(pageState)) {
                    QuestionPropertiesForm.this.processOptionGroup(formEvent);
                }
            }
        };
    }

    private void processQuestionnaire(FormSectionEvent formEvent) {
        FormData formData = formEvent.getFormData();
        PageState pageState = formEvent.getPageState();
        SimpleQuestionnaire questionnaire = FormBuildingPage.instance().getQuestionnaire(pageState);
        Integer questionPosition = FormBuildingPage.instance().getQuestionPosition(pageState);
        String questionText = formData.getString("question_text");
        if (questionPosition == null) {
            questionnaire.addQuestion(questionText, this.getPersistentWidget(pageState));
        } else {
            questionnaire.addQuestion(questionText, this.getPersistentWidget(pageState), (int)questionPosition);
        }
        questionnaire.save();
    }

    private void processDataTypes(FormSectionEvent formEvent) {
        FormData formData = formEvent.getFormData();
        PageState pageState = formEvent.getPageState();
        PersistentWidget widget = this.getPersistentWidget(pageState);
        if (this.isEditMode(pageState)) {
            widget.clearValidationListeners();
        }
        AttributeMetaData metaData = this.getParameterMetaData(pageState);
        boolean isRequired = false;
        if (metaData != null) {
            isRequired = metaData.isRequired();
        } else {
            String formIsRequired = formData.getString("isRequired");
            boolean bl = isRequired = formIsRequired != null && formIsRequired.equals("yes");
        }
        if (isRequired) {
            String listenerClassName = "com.arsdigita.bebop.parameters.NotEmptyValidationListener";
            PersistentParameterListener listener = new PersistentParameterListener(listenerClassName);
            widget.addValidationListener(listener);
        }
        if (widget instanceof PersistentTextField) {
            String parameterModel = null;
            parameterModel = this.hasParameterType(pageState) ? metaData.getAttributeType().getParameterModelClass().getName() : formData.getString("parameterModel");
            if (parameterModel != null) {
                widget.setParameterModel(parameterModel);
            }
        }
        widget.save();
    }

    private void processOptionGroup(FormSectionEvent formEvent) {
        FormData formData = formEvent.getFormData();
        PageState pageState = formEvent.getPageState();
        String nOptions = formData.get("nOptions").toString();
        this.m_nOptions.set(pageState, (Object)nOptions);
    }

    private FormSection getWidgetFormSection(PageState pageState) {
        FormSectionGenerator formGenerator = new FormSectionGenerator(this.getPersistentWidget(pageState));
        FormSection widgetFormSection = formGenerator.generateFormSection(false, FormBuildingPage.instance().getPageMode(pageState).equals("add"));
        this.m_propertiesProcessListener = formGenerator.getSetProcessListener();
        return widgetFormSection;
    }

    public PersistentWidget getPersistentWidget(PageState pageState) {
        return (PersistentWidget)this.m_persistentWidget.get(pageState);
    }

    private FormSection getDataTypeFormSection(PageState pageState) {
        PersistentWidget widget;
        FormSection typeSection = new FormSection();
        if (!FormBuildingPage.instance().getQuestionnaire(pageState).listenerHasMetaData()) {
            typeSection.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.is_answer_required")));
            RadioGroup requiredGroup = new RadioGroup("isRequired");
            requiredGroup.addOption(new Option("yes", "Yes"));
            requiredGroup.addOption(new Option("no", "No"));
            if (this.isAddMode(pageState)) {
                requiredGroup.setOptionSelected("no");
            } else {
                s_log.debug((Object)("setting option selected " + (this.questionIsRequired(pageState) ? "yes" : "no")));
                requiredGroup.setOptionSelected(this.questionIsRequired(pageState) ? "yes" : "no");
            }
            typeSection.add(requiredGroup);
        }
        if ((widget = this.getPersistentWidget(pageState)) instanceof PersistentTextField && !this.hasParameterType(pageState)) {
            typeSection.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.what_is_the_datatype_of_the_answer")));
            RadioGroup typeGroup = new RadioGroup("parameterModel");
            typeGroup.addOption(new Option("com.arsdigita.bebop.parameters.StringParameter", "Text"));
            typeGroup.addOption(new Option("com.arsdigita.bebop.parameters.NumberParameter", "Number"));
            typeGroup.addOption(new Option("com.arsdigita.bebop.parameters.URLParameter", "URL"));
            typeGroup.addOption(new Option("com.arsdigita.bebop.parameters.EmailParameter", "Email"));
            if (this.isAddMode(pageState)) {
                typeGroup.setOptionSelected("com.arsdigita.bebop.parameters.StringParameter");
            } else if (this.isEditMode(pageState)) {
                if (widget.getParameterModel() != null) {
                    typeGroup.setOptionSelected(widget.getParameterModel());
                } else {
                    typeGroup.setOptionSelected("text");
                }
            }
            typeSection.add(typeGroup);
        }
        return typeSection;
    }

    private boolean isOptionGroupQuestion(PageState pageState) {
        return this.getPersistentWidget(pageState) instanceof PersistentOptionGroup;
    }

    private FormSection getOptionGroupFormSection() {
        FormSection optionSection = new FormSection();
        optionSection.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.number_of_options_150_required")));
        TextField nOptionsField = new TextField(new NumberParameter("nOptions"));
        nOptionsField.addValidationListener(new NotEmptyValidationListener());
        nOptionsField.addValidationListener(new NumberInRangeValidationListener(1L, 50L));
        optionSection.add(nOptionsField);
        return optionSection;
    }

    public String getNumberOfOptions(PageState pageState) {
        if (this.isAddMode(pageState)) {
            return this.m_nOptions.get(pageState).toString();
        }
        PersistentOptionGroup optionGroup = (PersistentOptionGroup)this.getPersistentWidget(pageState);
        return Integer.toString(optionGroup.getOptions().size());
    }

    private boolean isAddMode(PageState pageState) {
        String pageMode = FormBuildingPage.instance().getPageMode(pageState);
        return pageMode.equals("add") || pageMode.equals("parameter");
    }

    private boolean isParameterMode(PageState pageState) {
        return FormBuildingPage.instance().getPageMode(pageState).equals("parameter");
    }

    private boolean isViewMode(PageState pageState) {
        return FormBuildingPage.instance().getPageMode(pageState).equals("view");
    }

    private boolean isEditMode(PageState pageState) {
        return FormBuildingPage.instance().getPageMode(pageState).equals("edit");
    }

    private boolean questionIsRequired(PageState pageState) {
        PersistentWidget widget = this.getPersistentWidget(pageState);
        return FormBuilderUtil.isRequired(widget);
    }

    public AttributeMetaData getParameterMetaData(PageState pageState) {
        String parameterName = FormBuildingPage.instance().getParameterName(pageState);
        if (parameterName == null) {
            return null;
        }
        AttributeMetaDataList metaDataList = FormBuildingPage.instance().getQuestionnaire(pageState).getListenerMetaData();
        if (metaDataList == null) {
            return null;
        }
        return metaDataList.getByParameterName(parameterName);
    }

    public boolean hasParameterType(PageState pageState) {
        AttributeMetaData metaData = this.getParameterMetaData(pageState);
        if (metaData == null) {
            return false;
        }
        return metaData.getAttributeType() != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

