/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.actions.ConfirmEmailListener;
import com.arsdigita.formbuilder.ui.editors.ProcessListenerForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class ConfirmEmailForm
extends ProcessListenerForm {
    private TextField m_from;
    private TextField m_subject;
    private TextArea m_body;

    public ConfirmEmailForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_from = new TextField(new EmailParameter("from"));
        this.m_from.setSize(50);
        this.m_from.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.from")), 4);
        section.add(this.m_from);
        this.m_subject = new TextField(new StringParameter("subject"));
        this.m_subject.setSize(50);
        this.m_subject.addValidationListener(new NotNullValidationListener());
        this.m_subject.addValidationListener(new StringInRangeValidationListener(1, 120));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.subject")), 4);
        section.add(this.m_subject);
        this.m_body = new TextArea(new StringParameter("body"));
        this.m_body.setRows(20);
        this.m_body.setCols(50);
        this.m_body.addValidationListener(new NotNullValidationListener());
        this.m_body.addValidationListener(new StringInRangeValidationListener(1, 4000));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.body")), 4);
        section.add(this.m_body);
    }

    protected PersistentProcessListener getProcessListener() {
        return new ConfirmEmailListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id) throws DataObjectNotFoundException {
        return new ConfirmEmailListener(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.initWidgets(e, listener);
        ConfirmEmailListener l = (ConfirmEmailListener)listener;
        PageState state = e.getPageState();
        if (l == null) {
            this.m_from.setValue(state, "");
            this.m_subject.setValue(state, "");
            this.m_body.setValue(state, "");
        } else {
            this.m_from.setValue(state, l.getFrom());
            this.m_subject.setValue(state, l.getSubject());
            this.m_body.setValue(state, l.getBody());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.processWidgets(e, listener);
        ConfirmEmailListener l = (ConfirmEmailListener)listener;
        FormData data = e.getFormData();
        String from = data.get("from").toString();
        String subject = (String)data.get("subject");
        String body = (String)data.get("body");
        l.setFrom(from);
        l.setSubject(subject);
        l.setBody(body);
    }
}

