/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.actions.ConfirmRedirectListener;
import com.arsdigita.formbuilder.ui.editors.ProcessListenerForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class ConfirmRedirectForm
extends ProcessListenerForm {
    private TextField m_url;

    public ConfirmRedirectForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_url = new TextField(new URLParameter("url"));
        this.m_url.setSize(50);
        this.m_url.addValidationListener(new NotNullValidationListener());
        this.m_url.addValidationListener(new StringInRangeValidationListener(1, 160));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.url")), 4);
        section.add(this.m_url);
    }

    protected PersistentProcessListener getProcessListener() {
        return new ConfirmRedirectListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id) throws DataObjectNotFoundException {
        return new ConfirmRedirectListener(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.initWidgets(e, listener);
        ConfirmRedirectListener l = (ConfirmRedirectListener)listener;
        PageState state = e.getPageState();
        if (l == null) {
            this.m_url.setValue(state, "");
        } else {
            this.m_url.setValue(state, l.getUrl());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentProcessListener listener) throws FormProcessException {
        super.processWidgets(e, listener);
        ConfirmRedirectListener l = (ConfirmRedirectListener)listener;
        FormData data = e.getFormData();
        String url = (String)data.get("url");
        l.setUrl(url);
    }
}

