/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentDate;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;
import java.util.Date;

public class DateForm
extends WidgetLabelForm {
    private com.arsdigita.bebop.form.Date m_value;
    private TextField m_startYear;
    private TextField m_endYear;

    public DateForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_value = new com.arsdigita.bebop.form.Date(new DateParameter("value"));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.default_value")), 4);
        section.add(this.m_value);
        this.m_startYear = new TextField(new IntegerParameter("startYear"));
        this.m_startYear.setDefaultValue(new Integer(1995));
        this.m_startYear.addValidationListener(new NotEmptyValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.start_year")));
        section.add(this.m_startYear);
        this.m_endYear = new TextField(new IntegerParameter("endYear"));
        this.m_endYear.setDefaultValue(new Integer(2004));
        this.m_endYear.addValidationListener(new NotEmptyValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.end_year")));
        section.add(this.m_endYear);
    }

    protected PersistentWidget getWidget() {
        return new PersistentDate();
    }

    protected PersistentWidget getWidget(BigDecimal id) throws DataObjectNotFoundException {
        return new PersistentDate(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        PersistentDate widget = (PersistentDate)w;
        PageState state = e.getPageState();
        if (widget == null) {
            this.m_value.setValue(state, new Date());
        } else {
            this.m_value.setValue(state, widget.getDefaultValue());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
        PersistentDate date = (PersistentDate)w;
        FormData data = e.getFormData();
        Date value = (Date)data.get("value");
        date.setDefaultValue(value);
        Integer startYear = (Integer)data.get("startYear");
        Integer endYear = (Integer)data.get("endYear");
        date.setYearRange(startYear, endYear);
    }
}

