/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentTextArea;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class TextAreaForm
extends WidgetLabelForm {
    private TextField m_width;
    private TextField m_height;
    private TextArea m_value;

    public TextAreaForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_width = new TextField(new IntegerParameter("width"));
        this.m_width.setSize(5);
        this.m_width.addValidationListener(new NotNullValidationListener());
        this.m_width.addValidationListener(new NumberInRangeValidationListener(1L, 70L));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.width")), 4);
        section.add(this.m_width);
        this.m_height = new TextField(new IntegerParameter("height"));
        this.m_height.setSize(5);
        this.m_height.addValidationListener(new NotNullValidationListener());
        this.m_height.addValidationListener(new NumberInRangeValidationListener(1L, 70L));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.height")), 4);
        section.add(this.m_height);
        this.m_value = new TextArea(new StringParameter("value"));
        this.m_value.setCols(50);
        this.m_value.setRows(20);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.default_value")), 4);
        section.add(this.m_value);
    }

    protected PersistentWidget getWidget() {
        return new PersistentTextArea();
    }

    protected PersistentWidget getWidget(BigDecimal id) throws DataObjectNotFoundException {
        return new PersistentTextArea(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        PersistentTextArea widget = (PersistentTextArea)w;
        PageState state = e.getPageState();
        if (widget == null) {
            this.m_width.setValue(state, "");
            this.m_height.setValue(state, "");
            this.m_value.setValue(state, "");
        } else {
            this.m_width.setValue(state, new Integer(widget.getCols()));
            this.m_height.setValue(state, new Integer(widget.getRows()));
            this.m_value.setValue(state, widget.getDefaultValue());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
        PersistentTextArea widget = (PersistentTextArea)w;
        FormData data = e.getFormData();
        Integer width = (Integer)data.get("width");
        Integer height = (Integer)data.get("height");
        String value = (String)data.get("value");
        widget.setCols(width);
        widget.setRows(height);
        widget.setDefaultValue(value);
    }
}

