/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentTextField;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.parameters.PersistentParameterListener;
import com.arsdigita.formbuilder.parameters.TextValidationListener;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;
import java.util.Iterator;

public class TextFieldForm
extends WidgetLabelForm {
    private TextField m_width;
    private TextField m_length;
    private TextField m_value;
    private SingleSelect m_datatype;
    private SingleSelectionModel m_control;

    public TextFieldForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
        this.m_control = control;
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_length = new TextField(new IntegerParameter("length"));
        this.m_length.setSize(5);
        this.m_length.addValidationListener(new NotNullValidationListener());
        this.m_length.addValidationListener(new NumberInRangeValidationListener(1L, 70L));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.max_length")), 4);
        section.add(this.m_length);
        this.m_width = new TextField(new IntegerParameter("width"));
        this.m_width.setSize(5);
        this.m_width.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.width")), 4);
        section.add(this.m_width);
        this.m_value = new TextField(new StringParameter("value"));
        this.m_value.setSize(50);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.default_value")), 4);
        section.add(this.m_value);
        this.m_datatype = new SingleSelect("datatype");
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.data_type")), 4);
        section.add(this.m_datatype);
        Integer[] types = TextValidationListener.getValidationTypes();
        for (int i = 0; i < types.length; ++i) {
            this.m_datatype.addOption(new Option(types[i].toString(), TextValidationListener.getValidationTypeName(types[i])));
        }
    }

    protected PersistentWidget getWidget() {
        return new PersistentTextField();
    }

    protected PersistentWidget getWidget(BigDecimal id) throws DataObjectNotFoundException {
        return new PersistentTextField(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        PersistentTextField widget = (PersistentTextField)w;
        PageState state = e.getPageState();
        if (widget == null) {
            this.m_width.setValue(state, "");
            this.m_length.setValue(state, "");
            this.m_value.setValue(state, "");
        } else {
            this.m_width.setValue(state, new Integer(widget.getSize()));
            this.m_length.setValue(state, new Integer(widget.getMaxLength()));
            this.m_value.setValue(state, widget.getDefaultValue());
        }
        TextValidationListener tfl = null;
        if (widget != null) {
            Iterator iter = widget.getValidationListeners().iterator();
            while (iter.hasNext()) {
                PersistentParameterListener l = (PersistentParameterListener)iter.next();
                if (!(l instanceof TextValidationListener)) continue;
                tfl = (TextValidationListener)l;
                break;
            }
        }
        if (tfl != null) {
            FormData d = e.getFormData();
            d.getParameter("datatype").setValue(tfl.getValidationType().toString());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
        PersistentTextField widget = (PersistentTextField)w;
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Integer length = (Integer)data.get("length");
        Integer width = (Integer)data.get("width");
        String value = (String)data.get("value");
        widget.setMaxLength(length);
        widget.setSize(width);
        widget.setDefaultValue(value);
        String validate = (String)this.m_datatype.getValue(state);
        TextValidationListener tfl = new TextValidationListener(new Integer(validate));
        widget.addValidationListener(tfl);
    }
}

