/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.jsp;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.ui.BaseAddObserver;
import com.arsdigita.formbuilder.ui.PlaceholdersInitListener;
import com.arsdigita.formbuilder.ui.jsp.FormNotFoundException;
import com.arsdigita.formbuilder.util.Placeholders;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JspForm
extends MetaForm {
    private HashMap m_vars = new HashMap();

    public JspForm(String name) {
        super(name);
    }

    public Form buildForm(PageState state) {
        try {
            PersistentForm f = this.getPersistentForm();
            f.setComponentAddObserver(new BaseAddObserver());
            Form form = (Form)f.createComponent();
            form.addInitListener(new JSPInitListener(this.m_vars));
            return form;
        }
        catch (FormNotFoundException ex) {
            throw new UncheckedWrapperException("Cannot find form", ex);
        }
    }

    public abstract PersistentForm getPersistentForm() throws FormNotFoundException;

    public void setVariable(String name, String value) {
        this.m_vars.put(name, value);
    }

    private class JSPInitListener
    extends PlaceholdersInitListener {
        HashMap m_vars;

        public JSPInitListener(HashMap vars) {
            this.m_vars = vars;
        }

        protected Placeholders getPlaceholders(PageState state) {
            Placeholders p = super.getPlaceholders(state);
            Iterator i = this.m_vars.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)this.m_vars.get(key);
                p.setVariable("jsp." + key, value);
            }
            return p;
        }
    }
}

