/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class Charset
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/Charset.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.globalization.Charset";

    public Charset() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Charset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Charset(DataObject dataObject) {
        super(dataObject);
    }

    protected void initialize() {
        super.initialize();
        try {
            if (this.isNew() && this.getID() == null) {
                this.setID(Sequences.getNextValue());
            }
        }
        catch (SQLException ex) {
            throw new UncheckedWrapperException("cannot set charset id", ex);
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get("id");
    }

    private void setID(BigDecimal id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be empty.");
        }
        if (this.isNew()) {
            this.set("id", id);
        }
    }

    public String getCharset() {
        return (String)this.get("charset");
    }

    public void setCharset(String charset) {
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset cannot be empty.");
        }
        this.set("charset", charset);
    }

    protected void afterSave() {
        super.afterSave();
        Globalization.loadLocaleToCharsetMap();
    }

    protected void afterDelete() {
        super.afterDelete();
        Globalization.loadLocaleToCharsetMap();
    }
}

