/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.globalization.Charset;
import com.arsdigita.globalization.Locale;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Globalization {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/Globalization.java#14 $$Author: mikeb $$DateTime: 2004/04/29 10:22:12 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$globalization$Globalization == null ? (class$com$arsdigita$globalization$Globalization = Globalization.class$("com.arsdigita.globalization.Globalization")) : class$com$arsdigita$globalization$Globalization));
    public static final String ENCODING_PARAM_NAME = "g11n.enc";
    public static final String DEFAULT_PARAM_ENCODING = "ISO-8859-1";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static Map s_localeToCharsetMap;
    private static String s_defaultCharset;
    static /* synthetic */ Class class$com$arsdigita$globalization$Globalization;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLocaleToCharsetMap() {
        Session s = SessionManager.getSession();
        TransactionContext tcontext = s.getTransactionContext();
        boolean startedTransaction = false;
        try {
            if (!tcontext.inTxn()) {
                tcontext.beginTxn();
                startedTransaction = true;
            }
            DataCollection locales = s.retrieve("com.arsdigita.globalization.Locale");
            locales.addNotEqualsFilter("defaultCharset.id", null);
            HashMap<String, String> map = new HashMap<String, String>();
            while (locales.next()) {
                Locale localeObject = new Locale(locales.getDataObject());
                java.util.Locale locale = localeObject.toJavaLocale();
                Charset defaultCharset = localeObject.getDefaultCharset();
                Assert.assertNotNull(defaultCharset, "DefaultCharset for locale \"" + locale + "\" (" + localeObject + ")");
                String charset = defaultCharset.getCharset();
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Mapping locale " + locale.toString() + " to charset " + charset));
                }
                map.put(locale.toString(), charset);
            }
            s_localeToCharsetMap = map;
        }
        finally {
            if (startedTransaction && tcontext.inTxn()) {
                tcontext.commitTxn();
            }
        }
    }

    static void setDefaultCharset(String encoding) {
        s_defaultCharset = encoding;
    }

    public static String getDefaultCharset() {
        return s_defaultCharset;
    }

    public static String getDefaultCharset(java.util.Locale locale) {
        String charset;
        if (locale == null || locale.toString().length() == 0) {
            throw new IllegalArgumentException("locale cannot be empty.");
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Looking for charset for locale " + locale.toString()));
        }
        if ((charset = (String)s_localeToCharsetMap.get(locale.toString())) != null) {
            return charset;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Looking for charset for language " + locale.getLanguage()));
        }
        if ((charset = (String)s_localeToCharsetMap.get(locale.getLanguage())) != null) {
            return charset;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Falling back on default encoding " + Globalization.getDefaultCharset()));
        }
        return Globalization.getDefaultCharset();
    }

    public static String getDefaultCharset(HttpServletRequest req) {
        String charset = req.getCharacterEncoding();
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    private static java.util.Locale getLocale(HttpServletRequest req) {
        java.util.Locale l = Kernel.getContext().getLocale();
        if (l == null) {
            l = req.getLocale();
        }
        if (l == null) {
            l = java.util.Locale.getDefault();
        }
        return l;
    }

    public static final String decodeParameter(HttpServletRequest r, String name) {
        String re = r.getParameter(ENCODING_PARAM_NAME);
        String original = r.getParameter(name);
        String real = null;
        if (re == null || re.length() == 0) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("g11n.enc is not set, using locale default encoding for parameter " + name));
            }
            re = Globalization.getDefaultCharset(Globalization.getLocale(r));
        }
        if (original == null || original.length() == 0) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " has no value"));
            }
            real = original;
        } else if (Globalization.getDefaultCharset(r).equals(re)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " is already in correct encoding"));
            }
            real = original;
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " is being converted from " + Globalization.getDefaultCharset(r) + " into " + re));
            }
            try {
                real = new String(original.getBytes(Globalization.getDefaultCharset(r)), re);
            }
            catch (UnsupportedEncodingException uee) {
                s_log.warn((Object)("encoding " + re + " is not supported, falling back on system default"));
                real = original;
            }
        }
        return real;
    }

    public static final String[] decodeParameters(HttpServletRequest r, String name) {
        String re = r.getParameter(ENCODING_PARAM_NAME);
        String[] originals = r.getParameterValues(name);
        String[] real = null;
        if (re == null || re.length() == 0) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("g11n.enc is not set, using locale default encoding for parameter " + name));
            }
            re = Globalization.getDefaultCharset(Globalization.getLocale(r));
        }
        if (originals == null || originals.length == 0) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " has no value"));
            }
            real = originals;
        } else if (Globalization.getDefaultCharset(r).equals(re)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " is already in correct encoding"));
            }
            real = originals;
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Parameter " + name + " is being converted from " + Globalization.getDefaultCharset(r) + " into " + re));
            }
            try {
                real = new String[originals.length];
                for (int i = 0; i < originals.length; ++i) {
                    real[i] = new String(originals[i].getBytes(Globalization.getDefaultCharset(r)), re);
                }
            }
            catch (UnsupportedEncodingException uee) {
                s_log.warn((Object)("encoding " + re + " is not supported, falling back on system default"));
                real = originals;
            }
        }
        return real;
    }

    public static ResourceBundle getResourceBundle() {
        return Globalization.getResourceBundle(DispatcherHelper.getRequest());
    }

    public static ResourceBundle getResourceBundle(HttpServletRequest r) {
        RequestContext rc = DispatcherHelper.getRequestContext(r);
        ResourceBundle rb = null;
        rb = rc.getResourceBundle();
        if (rb != null) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)(rb.getClass().getName() + " is the chosen ResourceBundle."));
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"No matching ResourceBundle found");
        }
        return rb;
    }

    public static Object getLocalizedObject(HttpServletRequest r, String key) {
        Object l7dObject;
        block9: {
            ResourceBundle rb = null;
            l7dObject = key;
            int separator = key.indexOf(35);
            if (separator < 0) {
                rb = Globalization.getResourceBundle(r);
            } else {
                java.util.Locale locale = Kernel.getContext().getLocale();
                String targetBundle = key.substring(0, separator);
                try {
                    rb = locale != null ? ResourceBundle.getBundle(targetBundle, locale) : ResourceBundle.getBundle(targetBundle);
                }
                catch (MissingResourceException mre) {
                    return key;
                }
                key = key.substring(separator + 1);
            }
            try {
                if (rb != null) {
                    l7dObject = rb.getObject(key);
                } else if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"No ResourceBundle available");
                }
            }
            catch (MissingResourceException e) {
                if (!s_log.isDebugEnabled()) break block9;
                s_log.debug((Object)("Key " + key + " was not found in the " + "ResourceBundle"));
            }
        }
        return l7dObject;
    }

    public static String getLocalizedString(HttpServletRequest r, String key) {
        return (String)Globalization.getLocalizedObject(r, key);
    }

    public static String getLocalizedString(HttpServletRequest r, String key, Object[] arguments) {
        String l7dString = Globalization.getLocalizedString(r, key);
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof String)) continue;
            arguments[i] = Globalization.getLocalizedString(r, (String)arguments[i]);
        }
        l7dString = MessageFormat.format(l7dString, arguments);
        return l7dString;
    }

    public static ResourceBundle getBundleNoFallback(String targetBundle, java.util.Locale locale, java.util.Locale defaultLocale) {
        ResourceBundle bundle;
        block8: {
            bundle = null;
            if (locale == null) {
                locale = defaultLocale != null ? defaultLocale : java.util.Locale.getDefault();
            }
            try {
                bundle = ResourceBundle.getBundle(targetBundle, locale);
            }
            catch (MissingResourceException e) {
                if (!s_log.isInfoEnabled()) break block8;
                s_log.info((Object)("Didn't find ResourceBundle for " + targetBundle));
            }
        }
        String targetLanguage = locale.getLanguage();
        if (bundle != null) {
            if (targetLanguage.equals(bundle.getLocale().getLanguage()) || targetLanguage.equals(defaultLocale.getLanguage())) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Found matching ResourceBundle for " + targetBundle));
                }
            } else {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Found non-matching ResourceBundle for " + targetBundle));
                }
                bundle = null;
            }
        }
        return bundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_defaultCharset = "ISO-8859-1";
        Globalization.loadLocaleToCharsetMap();
    }
}

