/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.Charset;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.GlobalizationException;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class Locale
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/Locale.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$globalization$Locale == null ? (class$com$arsdigita$globalization$Locale = Locale.class$("com.arsdigita.globalization.Locale")) : class$com$arsdigita$globalization$Locale).getName());
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.globalization.Locale";
    static /* synthetic */ Class class$com$arsdigita$globalization$Locale;

    public Locale() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Locale(String language) {
        this();
        this.setLanguage(language);
    }

    public Locale(String language, String country) {
        this();
        this.setLanguage(language);
        this.setCountry(country);
    }

    public Locale(String language, String country, String variant) {
        this();
        this.setLanguage(language);
        this.setCountry(country);
        this.setVariant(variant);
    }

    public Locale(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void initialize() {
        super.initialize();
        try {
            if (this.isNew() && this.getID() == null) {
                this.setID(Sequences.getNextValue());
            }
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public Locale(DataObject dataObject) {
        super(dataObject);
    }

    public Locale fallback() {
        Locale locale = null;
        if (this.getVariant() != null && this.getVariant().length() > 0) {
            try {
                locale = Locale.retrieve(this.getLanguage(), this.getCountry());
            }
            catch (DataObjectNotFoundException e) {
                try {
                    locale = Locale.retrieve(this.getLanguage());
                }
                catch (DataObjectNotFoundException e2) {
                    locale = null;
                }
            }
        } else if (this.getCountry() != null && this.getCountry().length() > 0) {
            try {
                locale = Locale.retrieve(this.getLanguage());
            }
            catch (DataObjectNotFoundException e) {
                locale = null;
            }
        }
        return locale;
    }

    public static Locale fallback(java.util.Locale locale) {
        Locale localeObject = null;
        if (locale != null) {
            String variant = locale.getVariant();
            String country = locale.getCountry();
            if (variant != null && variant.length() > 0) {
                try {
                    localeObject = Locale.retrieve(locale.getLanguage(), locale.getCountry());
                }
                catch (DataObjectNotFoundException e) {
                    try {
                        localeObject = Locale.retrieve(locale.getLanguage());
                    }
                    catch (DataObjectNotFoundException e2) {
                        localeObject = null;
                    }
                }
            } else if (country != null && country.length() > 0) {
                try {
                    localeObject = Locale.retrieve(locale.getLanguage());
                }
                catch (DataObjectNotFoundException e) {
                    localeObject = null;
                }
            }
        }
        return localeObject;
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get("id");
    }

    private void setID(BigDecimal id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be empty.");
        }
        if (this.isNew()) {
            this.set("id", id);
        }
    }

    public String getLanguage() {
        String language = (String)this.get("language");
        if (language == null) {
            language = "";
        }
        return language;
    }

    public void setLanguage(String language) {
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException("language cannot be empty.");
        }
        this.set("language", language);
    }

    public String getCountry() {
        String country = (String)this.get("country");
        if (country == null) {
            country = "";
        }
        return country;
    }

    public void setCountry(String country) {
        this.set("country", country);
    }

    public String getVariant() {
        String variant = (String)this.get("variant");
        if (variant == null) {
            variant = "";
        }
        return variant;
    }

    public void setVariant(String variant) {
        this.set("variant", variant);
    }

    public Charset getDefaultCharset() {
        DataObject charset = (DataObject)this.get("defaultCharset");
        Charset charsetObject = null;
        if (charset != null) {
            charsetObject = new Charset(charset);
        }
        return charsetObject;
    }

    public void setDefaultCharset(Charset charset) {
        this.setAssociation("defaultCharset", charset);
    }

    private static DataObject load(String language, String country, String variant) throws DataObjectNotFoundException {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException("No null arguemnts allowed.");
        }
        if (s_cat.isDebugEnabled()) {
            s_cat.debug((Object)("Attempting to load Locale for:  language = " + language + ", country = " + country + ", variant = " + variant));
        }
        Session s = SessionManager.getSession();
        DataCollection locales = s.retrieve(BASE_DATA_OBJECT_TYPE);
        DataObject locale = null;
        if (language.length() > 0) {
            locales.addEqualsFilter("language", language);
        } else {
            locales.addEqualsFilter("language", null);
        }
        if (country.length() > 0) {
            locales.addEqualsFilter("country", country);
        } else {
            locales.addEqualsFilter("country", null);
        }
        if (variant.length() > 0) {
            locales.addEqualsFilter("variant", variant);
        } else {
            locales.addEqualsFilter("variant", null);
        }
        if (locales.next()) {
            locale = locales.getDataObject();
            locales.close();
            return locale;
        }
        throw new DataObjectNotFoundException("Didn't find a corresponding Locale DomainObject");
    }

    public static Locale retrieve(String language) throws DataObjectNotFoundException {
        return Locale.retrieve(language, "", "");
    }

    public static Locale retrieve(String language, String country) throws DataObjectNotFoundException {
        return Locale.retrieve(language, country, "");
    }

    public static Locale retrieve(String language, String country, String variant) throws DataObjectNotFoundException {
        return new Locale(Locale.load(language, country, variant));
    }

    public static Locale fromJavaLocale(java.util.Locale locale) throws GlobalizationException {
        Locale localeObject = null;
        if (locale != null) {
            try {
                localeObject = Locale.retrieve(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
            catch (DataObjectNotFoundException e) {
                if (s_cat.isDebugEnabled()) {
                    s_cat.debug((Object)("Locale " + locale.toString() + " is not supported."));
                }
                throw new GlobalizationException("Locale " + locale.toString() + " is not supported.");
            }
        }
        return localeObject;
    }

    public static Locale fromJavaLocaleBestMatch(java.util.Locale locale) {
        Locale localeObject = null;
        if (locale != null) {
            try {
                localeObject = Locale.fromJavaLocale(locale);
            }
            catch (GlobalizationException ge) {
                localeObject = Locale.fallback(locale);
            }
        }
        return localeObject;
    }

    public java.util.Locale toJavaLocale() {
        String language = this.getLanguage();
        String country = this.getCountry();
        String variant = this.getVariant();
        if (country == null) {
            country = "";
        }
        if (variant == null) {
            variant = "";
        }
        return new java.util.Locale(language, country, variant);
    }

    public static java.util.Locale toJavaLocale(Locale locale) {
        return locale.toJavaLocale();
    }

    protected void beforeSave() {
        if (this.getDefaultCharset() == null) {
            Charset c = new Charset();
            c.setCharset("dummyCharset" + c.getID());
            c.save();
            this.setDefaultCharset(c);
        }
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        Globalization.loadLocaleToCharsetMap();
    }

    protected void afterDelete() {
        super.afterDelete();
        Globalization.loadLocaleToCharsetMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

