/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.initializer;

import com.arsdigita.initializer.InitializationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Configuration {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/initializer/Configuration.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    Map m_parameters = new HashMap();
    Map m_types = new HashMap();
    Map m_usage = new HashMap();

    public void initParameter(String name, String usage, Class type, Object defaultValue) throws InitializationException {
        if (this.m_parameters.containsKey(name)) {
            throw new InitializationException("Parameter " + name + " already defined.");
        }
        this.m_types.put(name, type);
        this.typeCheck(name, defaultValue);
        this.m_parameters.put(name, defaultValue);
        this.m_usage.put(name, usage);
    }

    public void initParameter(String name, String usage, Class type) throws InitializationException {
        this.initParameter(name, usage, type, null);
    }

    private void paramCheck(String name) throws InitializationException {
        if (!this.m_parameters.containsKey(name)) {
            throw new InitializationException("No such parameter: " + name + ", legal parameters are: " + this.getParameterNames());
        }
    }

    private void typeCheck(String name, Object value) throws InitializationException {
        if (value == null) {
            return;
        }
        Class cls = (Class)this.m_types.get(name);
        if (!cls.isInstance(value)) {
            throw new InitializationException("Parameter " + name + " must be of type " + cls.getName());
        }
    }

    public void setParameter(String name, Object value) throws InitializationException {
        this.m_parameters.put(name, value);
    }

    public Object getParameter(String name) throws InitializationException {
        return this.m_parameters.get(name);
    }

    public boolean hasParameter(String name) {
        return this.m_parameters.containsKey(name);
    }

    public Set getParameterNames() {
        return this.m_parameters.keySet();
    }

    public String toString() {
        return "<configuration parameters: " + this.m_parameters + ">";
    }
}

