/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.installer;

import com.arsdigita.installer.ParseException;
import com.arsdigita.installer.StatementParser;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class SQLLoader {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/installer/SQLLoader.java#8 $ by $Author: mbooth $, $DateTime: 2004/07/12 12:18:50 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$installer$SQLLoader == null ? (class$com$arsdigita$installer$SQLLoader = SQLLoader.class$("com.arsdigita.installer.SQLLoader")) : class$com$arsdigita$installer$SQLLoader));
    private Connection m_conn;
    static /* synthetic */ Class class$com$arsdigita$installer$SQLLoader;

    public SQLLoader(Connection conn) {
        this.m_conn = conn;
    }

    protected abstract Reader open(String var1);

    public static void load(Connection conn, String script) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (script == null) {
            throw new IllegalArgumentException();
        }
        SQLLoader loader = new SQLLoader(conn){

            protected final Reader open(String name) {
                ClassLoader cload = this.getClass().getClassLoader();
                InputStream is = cload.getResourceAsStream(name);
                if (is == null) {
                    return null;
                }
                return new InputStreamReader(is);
            }
        };
        loader.load(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name) {
        try {
            Statement stmt = this.m_conn.createStatement();
            try {
                this.load(stmt, name, null, name);
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    private void load(final Statement stmt, final String base, String from, final String name) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Loading " + name + " using base " + base));
        }
        try {
            Reader reader = this.open(name);
            if (reader == null) {
                throw new IllegalArgumentException("no such file: " + name + (from == null ? "" : ", included from: " + from));
            }
            StatementParser sp = new StatementParser(name, reader, new StatementParser.Switch(){

                public void onStatement(String sql) {
                    SQLLoader.this.execute(stmt, sql);
                }

                public void onInclude(String include, boolean relative) {
                    if (relative) {
                        s_log.debug((Object)"Relative include");
                        SQLLoader.this.include(stmt, base, name, include);
                    } else {
                        s_log.debug((Object)"Absolute include");
                        SQLLoader.this.include(stmt, base, base, include);
                    }
                }
            });
            sp.parse();
            reader.close();
        }
        catch (ParseException e) {
            throw new UncheckedWrapperException(e);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    private String parent(String path) {
        int index;
        if ((path = path.trim()).endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        path = (index = path.lastIndexOf(47)) > 0 ? path.substring(0, index) : null;
        return path;
    }

    private void include(Statement stmt, String base, String from, String included) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Resolving include: '" + included + "'"));
            s_log.debug((Object)("Base: '" + base + "'"));
            s_log.debug((Object)("From: '" + from + "'"));
        }
        String front = this.parent(from);
        String back = included;
        while (back.startsWith("../")) {
            back = back.substring(3);
            front = this.parent(front);
        }
        String resolved = front == null ? back : front + "/" + back;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Recursively including: '" + resolved + "'"));
        }
        this.load(stmt, base, from, resolved);
    }

    private void execute(Statement stmt, String sql) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Executing SQL " + sql));
        }
        try {
            stmt.execute(sql);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)(stmt.getUpdateCount() + " row(s) affected"));
            }
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(sql, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

