/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.db.DbHelper;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.MDUtil;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.SecurityLogger;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ACSObject
extends ObservableDomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/ACSObject.java#23 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.ACSObject";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$ACSObject == null ? (class$com$arsdigita$kernel$ACSObject = ACSObject.class$("com.arsdigita.kernel.ACSObject")) : class$com$arsdigita$kernel$ACSObject));
    public static final String ID = "id";
    public static final String OBJECT_TYPE = "objectType";
    public static final String DEFAULT_DOMAIN_CLASS = "defaultDomainClass";
    public static final String DISPLAY_NAME = "displayName";
    protected static final String CONTAINER = "container";
    static /* synthetic */ Class class$com$arsdigita$kernel$ACSObject;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ACSObject(DataObject acsObjectData) {
        super(acsObjectData);
    }

    public ACSObject() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ACSObject(String typeName) {
        super(typeName);
    }

    public ACSObject(ObjectType type) {
        super(type);
    }

    public ACSObject(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            if (this.get(ID) == null) {
                this.set(ID, ACSObject.generateID());
            }
            String typeName = this.getObjectType().getModel().getName() + "." + this.getObjectType().getName();
            this.set(OBJECT_TYPE, typeName);
            String className = this.getClass().getName();
            this.set(DEFAULT_DOMAIN_CLASS, className);
        } else {
            String baseType = this.getBaseDataObjectType();
            if (baseType != null) {
                ObjectType.verifySubtype(baseType, this.getSpecificObjectType());
            }
        }
        if (s_log.isDebugEnabled()) {
            Party party = Kernel.getContext().getEffectiveParty();
            s_log.debug((Object)((this.isNew() ? "Create" : "Load") + " object " + this.getOID() + " under party: " + (party == null ? null : party.getOID())));
        }
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ID);
    }

    public BigDecimal setID(BigDecimal id) {
        return this.getID();
    }

    public BigDecimal setID() throws PersistenceException {
        return this.getID();
    }

    public String getDisplayName() {
        return this.getSpecificObjectType() + " " + this.getID();
    }

    protected ACSObject getContainer() {
        ObjectType specificType = MDUtil.getType(this.getSpecificObjectType());
        Property p = MDUtil.getCompositeRole(specificType);
        DataObject containerData = null;
        if (p != null) {
            this.specializeDataObject(specificType);
            containerData = (DataObject)this.get(p.getName());
        }
        if (containerData == null && MDUtil.hasPackageInstanceRole(specificType)) {
            this.specializeDataObject(specificType);
            containerData = (DataObject)this.get("packageInstance");
        }
        return (ACSObject)DomainObjectFactory.newInstance(containerData);
    }

    protected boolean isContainerModified() {
        ObjectType specificType = MDUtil.getType(this.getSpecificObjectType());
        Property p = MDUtil.getCompositeRole(specificType);
        if (p != null) {
            this.specializeDataObject(specificType);
            if (this.isPropertyModified(p.getName())) {
                return true;
            }
            if (this.get(p.getName()) != null) {
                return false;
            }
        }
        if (MDUtil.hasPackageInstanceRole(specificType)) {
            this.specializeDataObject(specificType);
            return this.isPropertyModified("packageInstance");
        }
        return false;
    }

    public ACSObject gimmeContainer() {
        return this.getContainer();
    }

    public String getSpecificObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public OID getSpecificOID() {
        return new OID(this.getSpecificObjectType(), (Object)this.getID());
    }

    public String getDefaultDomainClass() {
        return (String)this.get(DEFAULT_DOMAIN_CLASS);
    }

    public final void assertPrivilege(PrivilegeDescriptor priv) {
        Party party = KernelHelper.getCurrentEffectiveParty();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Check privilege " + priv.getName() + " on object " + this.getOID() + " against party " + (party == null ? null : party.getOID())));
        }
        PermissionService.assertPermission(new PermissionDescriptor(priv, this, party));
    }

    public final boolean checkPrivilege(PrivilegeDescriptor priv) {
        Party party = KernelHelper.getCurrentEffectiveParty();
        return PermissionService.checkPermission(new PermissionDescriptor(priv, this, party));
    }

    public void doCreateCheck() {
        ACSObject container = this.getContainer();
        if (container == null) {
            SecurityLogger.log(Priority.INFO, "No parent container for " + this.getOID() + ".");
            return;
        }
        container.assertPrivilege(PrivilegeDescriptor.CREATE);
    }

    public void doWriteCheck() {
        this.assertPrivilege(PrivilegeDescriptor.WRITE);
    }

    protected void beforeSave() {
        String displayName = this.getDisplayName();
        if (displayName != null && !displayName.equals(this.get(DISPLAY_NAME))) {
            if (DbHelper.varcharLength(displayName) > 200) {
                displayName = DbHelper.truncateString(displayName, 197) + "...";
            }
            this.set(DISPLAY_NAME, displayName);
        }
        if (this.isContainerModified()) {
            ACSObject container = this.getContainer();
            this.setAssociation(CONTAINER, container);
        }
        super.beforeSave();
    }

    static BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique ACSObject id.";
            s_log.error((Object)"Unable to generate a unique ACSObject id.");
            throw PersistenceException.newInstance("Unable to generate a unique ACSObject id.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

