/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.domain.ReflectionInstantiator;
import com.arsdigita.persistence.DataObject;

public class ACSObjectInstantiator
extends DomainObjectInstantiator {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/ACSObjectInstantiator.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected boolean m_useReflectionForSubtypes = true;

    public DomainObjectInstantiator resolveInstantiator(DataObject dataObject) {
        String type = (String)dataObject.get("objectType");
        dataObject.specialize(type);
        DomainObjectInstantiator instantiator = DomainObjectFactory.getRegisteredInstantiator(dataObject.getObjectType());
        if (instantiator == null && (instantiator = DomainObjectFactory.getInstantiator(dataObject.getObjectType())) == this && ((ACSObjectInstantiator)instantiator).m_useReflectionForSubtypes) {
            String defaultDomainClass = (String)dataObject.get("defaultDomainClass");
            instantiator = ReflectionInstantiator.getInstantiator(defaultDomainClass);
        }
        return instantiator;
    }

    protected DomainObject doNewInstance(DataObject dataObject) {
        throw new UnsupportedOperationException("ACSObjectInstantiator should only be registered to handle ACSObject or an abstract subtype of ACSObject.  This instantiator cannot instantiate domain objects directly.  It can only delegate to other instantiators. Instantiator registration might be incorrect, or the data object might be invalid. DataObject is: " + dataObject);
    }
}

