/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.RoleCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Group
extends Party {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/Group.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Collection m_roles = new ArrayList();
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.Group";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Group(DataObject groupData) {
        super(groupData);
    }

    public Group() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Group(String typeName) {
        super(typeName);
    }

    public Group(ObjectType type) {
        super(type);
    }

    public Group(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Group(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public String getName() {
        return (String)this.get("name");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public PartyCollection getMembers() {
        return this.getMemberUsers();
    }

    public UserCollection getMemberUsers() {
        return new UserCollection(this.getMembersCursor());
    }

    public void addMember(User user) {
        this.add("members", user);
    }

    public void removeMember(User user) {
        this.remove("members", user);
    }

    public boolean hasDirectMember(Party party) {
        DataQuery members = this.getDataQuery("com.arsdigita.kernel.GroupDirectMembers");
        members.setParameter("groupID", this.getID());
        members.addEqualsFilter("memberID", party.getID());
        return members.size() == 1L;
    }

    public long countMembers() {
        DataQuery members = this.getDataQuery("com.arsdigita.kernel.GroupDirectMembers");
        members.setParameter("groupID", this.getID());
        return members.size();
    }

    public boolean hasDirectSubgroup(Group subgroup) {
        DataQuery subgroups = this.getDataQuery("com.arsdigita.kernel.GroupDirectSubgroups");
        subgroups.setParameter("groupID", this.getID());
        subgroups.addEqualsFilter("subgroupID", subgroup.getID());
        return subgroups.size() == 1L;
    }

    public long countSubgroups() {
        DataQuery subgroups = this.getDataQuery("com.arsdigita.kernel.GroupDirectSubgroups");
        subgroups.setParameter("groupID", this.getID());
        return subgroups.size();
    }

    public boolean isEmpty() {
        return this.countMembers() == 0L && this.countSubgroups() == 0L;
    }

    public void clearMembers() {
        DataOperation op = this.getDataOperation("com.arsdigita.kernel.ClearMembers");
        op.setParameter("groupID", this.getID());
        op.execute();
    }

    public void clearSubgroups() throws PersistenceException {
        DataOperation op = this.getDataOperation("com.arsdigita.kernel.ClearSubgroups");
        op.setParameter("groupID", this.getID());
        op.execute();
    }

    public void clearSupergroups() throws PersistenceException {
        DataOperation op = this.getDataOperation("com.arsdigita.kernel.ClearSupergroups");
        op.setParameter("groupID", this.getID());
        op.execute();
    }

    public GroupCollection getSubgroups() {
        return new GroupCollection(this.getSubgroupsCursor());
    }

    public void addSubgroup(Group subgroup) {
        this.add("subgroups", subgroup);
    }

    public void removeSubgroup(Group subgroup) {
        this.remove("subgroups", subgroup);
    }

    public GroupCollection getSupergroups() {
        return new GroupCollection(this.getSupergroupsCursor());
    }

    public void addSupergroup(Group supergroup) {
        this.add("supergroups", supergroup);
    }

    public void removeSupergroup(Group supergroup) {
        this.remove("supergroups", supergroup);
    }

    public PartyCollection getContainedParties() {
        DataCollection dc = this.getSession().retrieve("com.arsdigita.kernel.Party");
        Filter f = dc.addInSubqueryFilter("id", "com.arsdigita.kernel.ContainedParties");
        f.set("groupID", this.getID());
        return new PartyCollection(dc);
    }

    public GroupCollection getAllSubgroups() {
        return new GroupCollection(this.getAllSubgroupsCursor());
    }

    public GroupCollection getAllSupergroups() {
        DataAssociation da = (DataAssociation)this.get("allSupergroups");
        DataAssociationCursor cursor = da.getDataAssociationCursor();
        return new GroupCollection(cursor);
    }

    public PartyCollection getAllContainedParties() {
        DataCollection dc = this.getSession().retrieve("com.arsdigita.kernel.Party");
        Filter f = dc.addInSubqueryFilter("id", "com.arsdigita.kernel.AllContainedParties");
        f.set("groupID", this.getID());
        return new PartyCollection(dc);
    }

    public PartyCollection getAllMembers() {
        return this.getAllMemberUsers();
    }

    public UserCollection getAllMemberUsers() {
        DataAssociationCursor assoc = ((DataAssociation)this.get("allMembers")).cursor();
        return new UserCollection(assoc);
    }

    public boolean hasMember(Party party) {
        DataQuery members = this.getDataQuery("com.arsdigita.kernel.GroupMembers");
        members.setParameter("groupID", this.getID());
        members.addEqualsFilter("memberID", party.getID());
        return members.size() == 1L;
    }

    public long countAllMembers() {
        DataQuery members = this.getDataQuery("com.arsdigita.kernel.GroupMembers");
        members.setParameter("groupID", this.getID());
        return members.size();
    }

    public boolean hasSubgroup(Group subgroup) {
        DataQuery subgroups = this.getDataQuery("com.arsdigita.kernel.GroupSubgroups");
        subgroups.setParameter("groupID", this.getID());
        subgroups.addEqualsFilter("subgroupID", subgroup.getID());
        return subgroups.size() == 1L;
    }

    public long countAllSubgroups() {
        DataQuery subgroups = this.getDataQuery("com.arsdigita.kernel.GroupSubgroups");
        subgroups.setParameter("groupID", this.getID());
        return subgroups.size();
    }

    public boolean hasDirectMemberOrSubgroup(Party party) {
        if (party instanceof User) {
            return this.hasDirectMember((User)party);
        }
        if (party instanceof Group) {
            return this.hasDirectSubgroup((Group)party);
        }
        throw new IllegalArgumentException("Require a User or Group");
    }

    public void addMemberOrSubgroup(Party party) {
        if (party instanceof User) {
            this.addMember((User)party);
        } else if (party instanceof Group) {
            this.addSubgroup((Group)party);
        } else {
            throw new IllegalArgumentException("Require a User or Group");
        }
    }

    public void removeMemberOrSubgroup(Party party) {
        if (party instanceof User) {
            this.removeMember((User)party);
        } else if (party instanceof Group) {
            this.removeSubgroup((Group)party);
        } else {
            throw new IllegalArgumentException("Require a User or Group");
        }
    }

    public Role createRole(String roleName) {
        if (this.isNew()) {
            throw new RuntimeException("Roles can only be created after a group has been saved");
        }
        Role role = new Role(this, roleName);
        this.m_roles.add(role);
        return role;
    }

    public RoleCollection getRoles() {
        return new RoleCollection(this.getRolesCursor());
    }

    public Role getRole(String name) {
        DataAssociationCursor roles = this.getRolesCursor();
        roles.addEqualsFilter("name", name);
        if (!roles.next()) {
            return null;
        }
        DataObject role = roles.getDataObject();
        roles.close();
        return new Role(role);
    }

    public RoleCollection getOrderedRoles() {
        DataAssociationCursor roles = this.getRolesCursor();
        roles.addOrder("upper(name)");
        return new RoleCollection(roles);
    }

    protected void beforeSave() throws PersistenceException {
        super.beforeSave();
        Iterator iter = this.m_roles.iterator();
        while (iter.hasNext()) {
            Role r = (Role)iter.next();
            r.save();
        }
    }

    public void delete() throws PersistenceException {
        this.clearMembers();
        this.clearSubgroups();
        this.clearSupergroups();
        super.delete();
    }

    public static GroupCollection retrieveAll() {
        return new GroupCollection(SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE));
    }

    private DataAssociationCursor getRolesCursor() {
        DataAssociation assoc = (DataAssociation)this.get("roles");
        return assoc.cursor();
    }

    private DataAssociationCursor getMembersCursor() {
        DataAssociation assoc = (DataAssociation)this.get("members");
        return assoc.cursor();
    }

    private DataAssociationCursor getSubgroupsCursor() {
        DataAssociation assoc = (DataAssociation)this.get("subgroups");
        return assoc.cursor();
    }

    private DataAssociationCursor getSupergroupsCursor() {
        DataAssociation assoc = (DataAssociation)this.get("supergroups");
        return assoc.cursor();
    }

    private DataAssociationCursor getAllSubgroupsCursor() {
        DataAssociationCursor a = ((DataAssociation)this.get("allSubgroups")).cursor();
        return a;
    }

    private DataQuery getDataQuery(String name) {
        return SessionManager.getSession().retrieveQuery(name);
    }

    private DataOperation getDataOperation(String name) {
        return SessionManager.getSession().retrieveDataOperation(name);
    }
}

