/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ResourceCollection;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class Resource
extends ACSObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$Resource == null ? (class$com$arsdigita$kernel$Resource = Resource.class$("com.arsdigita.kernel.Resource")) : class$com$arsdigita$kernel$Resource));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.Resource";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String PARENT_RESOURCE = "parentResource";
    public static final String CHILD_RESOURCE = "childResource";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String TIMESTAMP = "timestamp";
    private boolean m_parentModified = false;
    static /* synthetic */ Class class$com$arsdigita$kernel$Resource;
    static /* synthetic */ Class class$com$arsdigita$kernel$ResourceType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;
    static /* synthetic */ Class class$com$arsdigita$kernel$ACSObject;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected Resource(DataObject dataObject) {
        super(dataObject);
    }

    protected Resource(String dataObjectType) {
        super(dataObjectType);
    }

    protected Resource(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static Resource createResource(ResourceType resourceType, String title, Resource parent) {
        Assert.exists(resourceType, class$com$arsdigita$kernel$ResourceType == null ? (class$com$arsdigita$kernel$ResourceType = Resource.class$("com.arsdigita.kernel.ResourceType")) : class$com$arsdigita$kernel$ResourceType);
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Resource.class$("java.lang.String")) : class$java$lang$String);
        return Resource.makeResource(resourceType, title, parent);
    }

    public static Resource createResource(String resourceObjectType, String title, Resource parent) {
        return Resource.createResource(ResourceType.retrieveResourceTypeForResource(resourceObjectType), title, parent);
    }

    private static Resource makeResource(ResourceType resourceType, String title, Resource parent) {
        String objectType = resourceType.getResourceObjectType();
        DataObject dataObject = SessionManager.getSession().create(objectType);
        dataObject.set("id", ACSObject.generateID());
        dataObject.set("objectType", objectType);
        dataObject.set(TITLE, title);
        Resource resource = Resource.retrieveResource(dataObject);
        Assert.exists(resource, class$com$arsdigita$kernel$Resource == null ? (class$com$arsdigita$kernel$Resource = Resource.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$kernel$Resource);
        resource.setResourceType(resourceType);
        if (parent != null) {
            resource.setParentResource(parent);
        }
        resource.setTitle(title);
        return resource;
    }

    protected void beforeSave() {
        if (this.isNew() || this.isPropertyModified(PARENT_RESOURCE)) {
            this.m_parentModified = true;
        }
        super.beforeSave();
        if (this.isModified()) {
            this.set(TIMESTAMP, new Date());
        }
    }

    protected void afterSave() {
        super.afterSave();
        if (this.m_parentModified) {
            Resource parent = this.getParentResource();
            if (parent != null) {
                PermissionService.setContext(this, parent);
            }
            this.m_parentModified = false;
        }
    }

    public static Resource retrieveResource(BigDecimal id) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE, (Object)id);
        return Resource.retrieveResource(oid);
    }

    public static Resource retrieveResource(OID oid) {
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        if (dataObject == null) {
            return null;
        }
        return Resource.retrieveResource(dataObject);
    }

    public static Resource retrieveResource(DataObject dobj) {
        Assert.exists(dobj, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Resource.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        ACSObject obj = (ACSObject)DomainObjectFactory.newInstance(dobj);
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        return Resource.getContainingResource(obj);
    }

    public static final Resource getContainingResource(ACSObject obj) {
        ACSObject result;
        Assert.exists(obj, class$com$arsdigita$kernel$ACSObject == null ? (class$com$arsdigita$kernel$ACSObject = Resource.class$("com.arsdigita.kernel.ACSObject")) : class$com$arsdigita$kernel$ACSObject);
        for (result = obj.gimmeContainer(); result != null && !(result instanceof Resource); result = result.gimmeContainer()) {
        }
        return (Resource)result;
    }

    public ResourceType getResourceType() {
        DataObject dataObject = (DataObject)this.get(RESOURCE_TYPE);
        Assert.exists(dataObject, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Resource.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        return new ResourceType(dataObject);
    }

    protected void setResourceType(ResourceType resourceType) {
        Assert.exists(resourceType, class$com$arsdigita$kernel$ResourceType == null ? (class$com$arsdigita$kernel$ResourceType = Resource.class$("com.arsdigita.kernel.ResourceType")) : class$com$arsdigita$kernel$ResourceType);
        this.setAssociation(RESOURCE_TYPE, resourceType);
    }

    public Resource getParentResource() {
        DataObject dataObject = (DataObject)this.get(PARENT_RESOURCE);
        if (dataObject == null) {
            return null;
        }
        return Resource.retrieveResource(dataObject);
    }

    public void setParentResource(Resource resource) {
        this.setAssociation(PARENT_RESOURCE, resource);
    }

    public ResourceCollection getChildResources() {
        DataAssociation association = (DataAssociation)this.get(CHILD_RESOURCE);
        return new ResourceCollection(association.cursor());
    }

    public String getTitle() {
        String title = (String)this.get(TITLE);
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Resource.class$("java.lang.String")) : class$java$lang$String);
        return title;
    }

    public void setTitle(String title) {
        Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Resource.class$("java.lang.String")) : class$java$lang$String);
        this.set(TITLE, title);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public Date getTimestamp() {
        return (Date)this.get(TIMESTAMP);
    }

    public static ResourceCollection retrieveAllResources() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ResourceCollection rcs = new ResourceCollection(dataCollection);
        return rcs;
    }

    public String getDisplayName() {
        return this.getTitle();
    }

    protected ACSObject getContainer() {
        return this.getParentResource();
    }

    protected boolean isContainerModified() {
        return this.isPropertyModified(PARENT_RESOURCE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

