/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.PackageEventListener;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNodeCollection;
import com.arsdigita.kernel.StyleAssociation;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.HierarchyDenormalization;
import com.arsdigita.web.PathMapCache;
import java.math.BigDecimal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SiteNode
extends ACSObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/SiteNode.java#32 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String s_typeName = "com.arsdigita.kernel.SiteNode";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$SiteNode == null ? (class$com$arsdigita$kernel$SiteNode = SiteNode.class$("com.arsdigita.kernel.SiteNode")) : class$com$arsdigita$kernel$SiteNode).getName());
    private static final Cache s_cache = new Cache();
    private static SiteNode s_rootSiteNode;
    private HierarchyDenormalization m_hierarchy;
    static /* synthetic */ Class class$com$arsdigita$kernel$SiteNode;

    protected String getBaseDataObjectType() {
        return s_typeName;
    }

    public SiteNode() {
        super(s_typeName);
    }

    public SiteNode(DataObject dataObject) {
        super(dataObject);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set("isDirectory", Boolean.TRUE);
            this.set("isPattern", Boolean.FALSE);
        }
        this.m_hierarchy = new HierarchyDenormalization("com.arsdigita.kernel.updateSiteNodeDescendants", this, "url"){};
    }

    public SiteNode(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(s_typeName, (Object)id));
    }

    public SiteNode(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getURL(HttpServletRequest req) {
        return this.getURL(req == null ? (String)null : req.getContextPath());
    }

    public String getUrl(HttpServletRequest req) {
        return this.getURL(req);
    }

    public String getURL(String contextPath) {
        if (contextPath != null) {
            return contextPath + this.getURLNoContext();
        }
        return this.getURLNoContext();
    }

    public String getUrl(String contextPath) {
        return this.getURL(contextPath);
    }

    public String getURL() {
        return this.getURLNoContext();
    }

    private void setURL() {
        s_log.debug((Object)("Setting url: " + this.getURLFromParent()));
        this.set("url", this.getURLFromParent());
    }

    private String getURLFromParent() {
        SiteNode parent = this.getParent();
        if (parent != null) {
            return parent.getURL() + this.getName() + "/";
        }
        return this.getName() + "/";
    }

    public String getURLNoContext() {
        String value = (String)this.get("url");
        if (value == null) {
            return "/";
        }
        return value;
    }

    public BigDecimal getNodeId() {
        return (BigDecimal)this.get("id");
    }

    public void setName(String name) {
        this.set("name", name);
        this.setURL();
    }

    public void setParent(SiteNode siteNode) {
        if (siteNode == null) {
            this.set("parent", null);
        } else if (((Boolean)siteNode.get("isDirectory")).booleanValue()) {
            this.setAssociation("parent", siteNode);
        }
        this.setURL();
    }

    public String getName() {
        String name = (String)this.get("name");
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getDisplayName() {
        return this.getURL();
    }

    public boolean isDirectory() {
        return (Boolean)this.get("isDirectory");
    }

    public boolean isPattern() {
        return (Boolean)this.get("isPattern");
    }

    public PackageInstance getPackageInstance() {
        DataObject dataObject = (DataObject)this.get("mountedObject");
        if (dataObject != null) {
            return new PackageInstance(dataObject);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"No package mounted; returning null");
        }
        return null;
    }

    public void mountPackage(PackageInstance pkg) {
        this.unMountPackage();
        this.setAssociation("mountedObject", pkg);
        PackageEventListener[] pels = pkg.getType().getListeners();
        for (int i = 0; i < pels.length; ++i) {
            PackageEventListener listener = pels[i];
            listener.onMount(this, pkg);
        }
    }

    public void unMountPackage() {
        PackageInstance pkg = this.getPackageInstance();
        if (pkg != null) {
            PackageEventListener[] pels = pkg.getType().getListeners();
            for (int i = 0; i < pels.length; ++i) {
                PackageEventListener listener = pels[i];
                listener.onUnmount(this, pkg);
            }
            this.set("mountedObject", null);
        }
    }

    public SiteNode getParent() {
        DataObject dataObject = (DataObject)this.get("parent");
        if (dataObject == null || dataObject.get("id") == null) {
            return null;
        }
        return new SiteNode(dataObject);
    }

    public SiteNodeCollection getChildren() {
        DataAssociation childAssociation = (DataAssociation)this.get("children");
        return new SiteNodeCollection(childAssociation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteNode getRootSiteNode() {
        if (s_rootSiteNode == null || !s_rootSiteNode.isValid()) {
            Session ssn = SessionManager.getSession();
            DataCollection rootSiteNode = SessionManager.getSession().retrieve(s_typeName);
            rootSiteNode.addEqualsFilter("name", null);
            rootSiteNode.addEqualsFilter("parent.id", null);
            if (rootSiteNode.next()) {
                try {
                    DataObject dobj = ssn.retrieve(new OID(s_typeName, rootSiteNode.get("id")));
                    dobj.disconnect();
                    s_rootSiteNode = new SiteNode(dobj);
                }
                finally {
                    rootSiteNode.close();
                }
            } else {
                throw new DataObjectNotFoundException("getRootSiteNode: Root site node not found.");
            }
            rootSiteNode.close();
        }
        return s_rootSiteNode;
    }

    public static void repopulateCache() {
        s_cache.refresh();
    }

    public static SiteNode getSiteNode(String path, boolean readOnly) throws DataObjectNotFoundException {
        SiteNode siteNode;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Finding the site node for path '" + path + "'"));
        }
        if ((siteNode = s_cache.getNode(path)) == null) {
            throw new DataObjectNotFoundException("RootSiteNode not available.  The data model is not properly loaded.");
        }
        return readOnly ? siteNode : new SiteNode(siteNode.getOID());
    }

    public static SiteNode getSiteNode(String path) throws DataObjectNotFoundException {
        return SiteNode.getSiteNode(path, false);
    }

    public static SiteNode createSiteNode(String name) {
        return SiteNode.createSiteNode(name, SiteNode.getRootSiteNode());
    }

    protected void beforeSave() {
        if (this.isPropertyModified("url") || this.isNew()) {
            s_cache.scheduleRefresh();
        }
        super.beforeSave();
    }

    public void afterDelete() {
        s_cache.scheduleRefresh();
    }

    public static SiteNode createSiteNode(String name, SiteNode parent) {
        SiteNode siteNode = new SiteNode();
        siteNode.setName(name);
        siteNode.setParent(parent);
        siteNode.save();
        return siteNode;
    }

    public String toString() {
        return "[url: " + this.getURL() + "]";
    }

    public void addStylesheet(Stylesheet sheet) {
        sheet.addToAssociation((DataAssociation)this.get("defaultStyle"));
    }

    public Stylesheet[] getStylesheets(Locale locale, String outputType) {
        return StyleAssociation.getStylesheets(this.get("defaultStyle"), locale, outputType);
    }

    public Stylesheet getStylesheet(Locale locale, String outputType) {
        return StyleAssociation.getStylesheet(this.get("defaultStyle"), locale, outputType);
    }

    public void removeStylesheet(Stylesheet sheet) {
        sheet.removeFromAssociation((DataAssociation)this.get("defaultStyle"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Cache
    extends PathMapCache {
        public Cache() {
            super("SiteNodeCache");
        }

        public String normalize(String path) {
            if (path == null) {
                throw new NullPointerException("path");
            }
            if (!path.startsWith("/")) {
                throw new DataObjectNotFoundException("The URL path specified must begin with a '/'.");
            }
            return path.endsWith("/") ? path : path + "/";
        }

        public Object retrieve(String path) {
            DataCollection dc = SessionManager.getSession().retrieve(SiteNode.s_typeName);
            dc.addEqualsFilter("url", path);
            SiteNode siteNode = null;
            if (dc.next()) {
                DataObject dobj = dc.getDataObject();
                dobj.disconnect();
                siteNode = new SiteNode(dobj);
                if (dc.next()) {
                    s_log.error((Object)("More than one site node found for url " + path + " ids: " + siteNode.getID() + " and " + dc.get("id")));
                }
                dc.close();
            }
            return siteNode == null ? null : new SiteNodeWrapper(siteNode);
        }

        public void refresh() {
            this.clearAll();
        }

        void scheduleRefresh() {
            super.refreshAfterCommit();
        }

        synchronized SiteNode getNode(String path) {
            SiteNodeWrapper snw = (SiteNodeWrapper)super.get(path);
            return snw.m_node;
        }
    }

    private static class SiteNodeWrapper {
        final SiteNode m_node;

        SiteNodeWrapper(SiteNode node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            this.m_node = node;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            SiteNodeWrapper snw = (SiteNodeWrapper)obj;
            return this.m_node.getID().equals(snw.m_node.getID()) && this.m_node.getURL().equals(snw.m_node.getURL());
        }

        public int hashCode() {
            return this.m_node.getID().hashCode() + this.m_node.getURL().hashCode();
        }

        public String toString() {
            return this.m_node.toString();
        }
    }
}

