/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;

public class User
extends Party {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/User.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private PersonName m_name;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.User";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static User retrieve(BigDecimal id) throws DataObjectNotFoundException {
        return User.retrieve(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static User retrieve(OID oid) throws DataObjectNotFoundException {
        User user = (User)DomainObjectFactory.newInstance(oid);
        if (user == null) {
            throw new DataObjectNotFoundException("Domain object factory produced null user for OID " + oid);
        }
        return user;
    }

    public static User retrieve(DataObject userData) {
        User user = (User)DomainObjectFactory.newInstance(userData);
        if (user == null) {
            throw new RuntimeException("Domain object factory produced null user for data object " + userData);
        }
        return user;
    }

    public static UserCollection retrieveAll() {
        return new UserCollection(SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE));
    }

    public User(DataObject userData) {
        super(userData);
    }

    public User() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public User(String givenName, String familyName, String email) {
        this(BASE_DATA_OBJECT_TYPE);
        this.getPersonName().setGivenName(givenName);
        this.getPersonName().setFamilyName(familyName);
        this.setPrimaryEmail(new EmailAddress(email));
    }

    public User(String typeName) {
        super(typeName);
    }

    public User(ObjectType type) throws DataObjectNotFoundException {
        super(type);
    }

    public User(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public User(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.m_name = new PersonName();
            this.setAssociation("name", this.m_name);
        }
    }

    public String getScreenName() {
        return (String)this.get("screenName");
    }

    public void setScreenName(String screenName) {
        this.set("screenName", screenName);
    }

    public PersonName getPersonName() {
        if (this.m_name == null) {
            DataObject nameData = (DataObject)this.get("name");
            this.m_name = new PersonName(nameData);
        }
        return this.m_name;
    }

    public String getName() {
        return this.getPersonName().toString();
    }

    public void setPrimaryEmail(EmailAddress emailAddress) {
        if (emailAddress == null) {
            throw new IllegalArgumentException("User's primary email cannot be null");
        }
        super.setPrimaryEmail(emailAddress);
    }

    public GroupCollection getAllGroups() {
        DataAssociationCursor assoc = ((DataAssociation)this.get("allGroups")).cursor();
        return new GroupCollection(assoc);
    }

    public GroupCollection getGroups() {
        DataAssociationCursor assoc = ((DataAssociation)this.get("groups")).cursor();
        return new GroupCollection(assoc);
    }

    protected void beforeSave() throws PersistenceException {
        super.beforeSave();
        if ((this.isNew() || this.isPropertyModified("primaryEmail")) && KernelHelper.emailIsPrimaryIdentifier()) {
            this.validatePrimaryEmail();
        }
        if ((this.isNew() || this.isPropertyModified("primaryEmail") || this.isPropertyModified("screenName")) && !KernelHelper.emailIsPrimaryIdentifier()) {
            if (this.getPrimaryEmail() == null) {
                throw new RuntimeException("Primary email must be specified");
            }
            this.validateScreenName();
        }
    }

    protected void afterSave() {
        super.afterSave();
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, this, this);
        PermissionService.grantPermission(perm);
    }

    public void delete() throws PersistenceException {
        this.clearUserFromGroups();
        super.delete();
    }

    public void clearUserFromGroups() throws PersistenceException {
        DataOperation op = this.getDataOperation("com.arsdigita.kernel.ClearUserFromGroups");
        op.setParameter("memberID", this.getID());
        op.execute();
    }

    protected void validatePrimaryEmail() {
        EmailAddress email = this.getPrimaryEmail();
        if (email == null) {
            throw new RuntimeException("Primary email must be specified");
        }
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.UserPrimaryEmail");
        Filter f = query.addFilter("primaryEmailAddress=:email and userID != :userID");
        f.set("email", email.getEmailAddress());
        f.set("userID", this.getID());
        if (query.size() > 0L) {
            throw new RuntimeException("Primary email must be unique among users");
        }
    }

    protected void validateScreenName() {
        String sn = this.getScreenName().toLowerCase();
        if (sn == null) {
            throw new RuntimeException("Screen Name must be specified");
        }
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.UserPrimaryEmail");
        Filter f = query.addFilter("lowerScreenName=:sn and userID != :userID");
        f.set("sn", sn);
        f.set("userID", this.getID());
        if (query.size() > 0L) {
            throw new RuntimeException("Screen Name must be unique among users");
        }
    }

    private DataOperation getDataOperation(String name) {
        return SessionManager.getSession().retrieveDataOperation(name);
    }
}

