/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;

public final class UserFactory {
    public static User newUser(EmailAddress primaryEmail, String givenName, String familyName, String password, String passwordQuestion, String passwordAnswer, String screenName, String uri, EmailAddress additionalEmail) {
        Assert.assertNotNull(primaryEmail, "primaryEmail");
        Assert.assertNotNull(givenName, "givenName");
        Assert.assertNotNull(familyName, "familyName");
        Assert.assertNotNull(password, "password");
        Assert.assertNotNull(passwordQuestion, "passwordQuestion");
        Assert.assertNotNull(passwordAnswer, "passwordAnswer");
        User user = new User();
        user.setPrimaryEmail(primaryEmail);
        PersonName name = user.getPersonName();
        name.setGivenName(givenName);
        name.setFamilyName(familyName);
        user.setScreenName(screenName);
        if (!StringUtils.emptyString(uri)) {
            user.setURI(uri);
        }
        if (null != additionalEmail) {
            user.addEmailAddress(additionalEmail);
        }
        user.save();
        UserAuthentication auth = UserAuthentication.createForUser(user);
        auth.setPassword(password);
        auth.setPasswordQuestion(passwordQuestion);
        auth.setPasswordAnswer(passwordAnswer);
        auth.save();
        return user;
    }
}

