/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.SecurityLogger;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import org.apache.log4j.Priority;

public class PermissionException
extends RuntimeException {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PermissionException.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private PermissionDescriptor m_permission;
    private String m_msg;

    public PermissionException(PrivilegeDescriptor priv, ACSObject obj) {
        this.m_permission = null;
        this.m_msg = "Unauthenticated party does not have the " + priv + " privilege on Object " + obj.getOID() + ".";
        SecurityLogger.log(Priority.WARN, this.m_msg);
    }

    public PermissionException(PermissionDescriptor permission) {
        this.m_permission = permission;
        OID partyOID = this.m_permission.getPartyOID();
        String userID = partyOID == null ? null : "" + partyOID.get("id");
        String priv = this.m_permission.getPrivilegeDescriptor().getDisplayName();
        String objectID = "" + this.m_permission.getACSObjectOID().toString();
        String contextID = null;
        DataObject context = PermissionService.getContext(this.m_permission.getACSObjectOID());
        if (context != null) {
            contextID = context.getOID().toString();
        }
        this.m_msg = "User " + userID + " does not have the " + priv + " privilege " + " on Object " + objectID + " with context " + contextID;
        SecurityLogger.log(Priority.WARN, this.m_msg);
    }

    public PermissionException(PrivilegeDescriptor priv, ACSObject obj, String message) {
        this.m_permission = null;
        this.m_msg = "Permission denied. Attempted operation using " + priv + " on Object " + obj.getOID() + ": " + message;
        SecurityLogger.log(Priority.WARN, this.m_msg);
    }

    public PermissionDescriptor getPermission() {
        return this.m_permission;
    }

    public String getMessage() {
        return this.m_msg;
    }
}

