/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelConfig;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.ObjectContext;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.Permission;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class PermissionManager {
    private static final String OBJECT_ID_ATTRIBUTE = "id";
    private static final String PARTY_ID_ATTRIBUTE = "id";
    public static final int VIRTUAL_PUBLIC_ID = -200;
    public static final int VIRTUAL_REGISTERED_ID = -202;
    public static final int SYSTEM_PARTY = -204;

    public boolean checkPermission(PermissionDescriptor permission) {
        boolean isUser = true;
        OID partyOID = permission.getPartyOID();
        if (partyOID == null) {
            return this.checkPermission(new PermissionDescriptor(permission.getPrivilegeDescriptor(), permission.getACSObjectOID(), this.getPublicPartyOID()));
        }
        String queryName = "CheckPermissionForParty";
        return this.doCheck(queryName, permission);
    }

    boolean checkDirectPermission(PermissionDescriptor permission) {
        return this.checkDirectPermission(permission, true);
    }

    boolean checkDirectPermission(PermissionDescriptor permission, boolean useImpliedPrivs) {
        if (useImpliedPrivs) {
            return this.doCheck("CheckDirectGrantWithImpliedPrivileges", permission);
        }
        DataQuery query = this.getQuery("CheckDirectGrant");
        query.setParameter("privilege", permission.getPrivilegeDescriptor().getName());
        query.setParameter("objectID", permission.getACSObjectOID().get("id"));
        query.setParameter("partyID", permission.getPartyOID().get("id"));
        if (query.next()) {
            query.close();
            return true;
        }
        query.close();
        return false;
    }

    private boolean checkPermission(UniversalPermissionDescriptor permission) {
        return this.doCheck("CheckUninheritedPermissionForParty", permission);
    }

    private boolean doCheck(String queryName, PermissionDescriptor permission) {
        DataQuery query = this.getQuery("PermissionCheckPlaceholder");
        Filter f = query.addFilter(" exists ( com.arsdigita.kernel.permissions." + queryName + " and  RAW[" + permission.getPrivilegeDescriptor().getColumnName() + " = 1 ])");
        f.set("objectID", permission.getACSObjectOID().get("id"));
        f.set("partyID", permission.getPartyOID().get("id"));
        if (query.next()) {
            query.close();
            return true;
        }
        query.close();
        return false;
    }

    public void grantPermission(PermissionDescriptor permission) {
        OID partyOID = permission.getPartyOID();
        if (partyOID != null && !this.checkDirectPermission(permission, false)) {
            final Permission p = new Permission();
            p.setPartyOID(partyOID);
            p.setACSObjectOID(permission.getACSObjectOID());
            p.setPrivilege(permission.getPrivilegeDescriptor());
            if (KernelConfig.isPermissionCheckEnabled()) {
                p.save();
            } else {
                new KernelExcursion(){

                    public void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        p.save();
                    }
                }.run();
            }
        }
    }

    public void revokePermission(PermissionDescriptor permission) {
        OID partyOID = permission.getPartyOID();
        if (partyOID != null) {
            try {
                Permission p = new Permission(this.createPermissionOID(permission));
                p.delete();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public DataObject getContext(OID oid) {
        try {
            ObjectContext objContext = new ObjectContext(oid.get("id"));
            return objContext.getContext();
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    public DataObject getContext(ACSObject acsObject) {
        return this.getContext(acsObject.getOID());
    }

    public void setContext(ACSObject acsObject, ACSObject context) throws PersistenceException {
        ObjectContext objContext;
        try {
            objContext = new ObjectContext(acsObject.getID());
        }
        catch (DataObjectNotFoundException e) {
            objContext = new ObjectContext();
            objContext.setObject(acsObject);
        }
        objContext.setContext(context);
    }

    public void setContext(OID acsObjectOID, OID contextOID) throws PersistenceException {
        ObjectContext objContext;
        try {
            objContext = new ObjectContext(acsObjectOID.get("id"));
        }
        catch (DataObjectNotFoundException e) {
            objContext = new ObjectContext();
            objContext.setObject(acsObjectOID);
        }
        objContext.setContext(contextOID);
    }

    public void clonePermissions(ACSObject acsObject) throws PersistenceException {
        this.clonePermissions(acsObject.getOID());
    }

    public void clonePermissions(OID acsObjectOID) throws PersistenceException {
        DataObject permParent = this.getContext(acsObjectOID);
        this.setContext(acsObjectOID, null);
        if (permParent != null) {
            ObjectPermissionCollection perms = this.getGrantedPermissions(permParent.getOID());
            while (perms.next()) {
                PermissionDescriptor desc = new PermissionDescriptor(perms.getPrivilege(), acsObjectOID, perms.getGranteeOID());
                this.grantPermission(desc);
            }
        }
    }

    public ObjectPermissionCollection getGrantedPermissions(OID acsObjectOID) {
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.ACSObject", acsObjectOID.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the ACSObject has an invalid object type.\nExpecting: com.arsdigita.kernel.ACSObject\nActual: " + acsObjectOID.getObjectType().getQualifiedName(), e);
        }
        DataQuery query = this.getQuery("ObjectPermissionCollection");
        query.setParameter("objectID", acsObjectOID.get("id"));
        query.addOrder("isInherited");
        query.addOrder("granteeID");
        query.addOrder("privilege");
        return new ObjectPermissionCollection(query);
    }

    public ObjectPermissionCollection getGrantedUniversalPermissions() {
        return this.getGrantedPermissions(UniversalPermissionDescriptor.ROOT_CONTEXT_OID);
    }

    public void filterObjects(DataCollection dataCollection, PrivilegeDescriptor privilege, OID partyOID) {
        ObjectType.verifySubtype("com.arsdigita.kernel.ACSObject", dataCollection.getObjectType());
        this.filterQuery(dataCollection, "id", privilege, partyOID);
    }

    public void filterQuery(DataQuery dataQuery, String propertyName, PrivilegeDescriptor privilege, OID partyOID) {
        partyOID = this.checkOID(partyOID);
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.Party", partyOID.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the Party has an invalid object type.\nExpecting: com.arsdigita.kernel.Party\nActual: " + partyOID.getObjectType().getQualifiedName(), e);
        }
        Filter f = this.getFilterQuery(dataQuery.getFilterFactory(), propertyName, privilege, partyOID);
        dataQuery.addFilter(f);
    }

    public Filter getFilterQuery(FilterFactory factory, String propertyName, PrivilegeDescriptor privilege, OID partyOID) {
        partyOID = this.checkOID(partyOID);
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.Party", partyOID.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the Party has an invalid object type.\nExpecting: com.arsdigita.kernel.Party\nActual: " + partyOID.getObjectType().getQualifiedName(), e);
        }
        UniversalPermissionDescriptor universalPermission = new UniversalPermissionDescriptor(privilege, partyOID);
        if (!this.checkPermission(universalPermission)) {
            Filter f = factory.simple(" exists ( com.arsdigita.kernel.permissions.PartyPermissionFilterQuery and RAW[dogc.pd_object_id] = " + propertyName + " and  RAW[" + privilege.getColumnName() + " = 1 ])");
            f.set("partyID", partyOID.get("id"));
            return f;
        }
        return factory.simple("1 = 1");
    }

    public Filter getObjectFilterQuery(FilterFactory factory, String propertyName, PrivilegeDescriptor privilege, OID objectOID) {
        Filter f = factory.simple(" exists ( com.arsdigita.kernel.permissions.ObjectPermissionFilterQuery and RAW[dgm.pd_member_id] = " + propertyName + " and  RAW[" + privilege.getColumnName() + " = 1 ]) ");
        f.set("objectID", objectOID.get("id"));
        return f;
    }

    public Iterator getPrivileges(OID object, OID party) {
        return this.getPrivilegeSet(object, party, false).iterator();
    }

    public Iterator getImpliedPrivileges(OID object, OID party) {
        return this.getPrivilegeSet(object, party, true).iterator();
    }

    private HashSet getPrivilegeSet(OID object, OID party, boolean impliedPrivs) {
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.ACSObject", object.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the ACSObject has an invalid object type.\nExpecting: com.arsdigita.kernel.ACSObject\nActual: " + object.getObjectType().getQualifiedName(), e);
        }
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.Party", party.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the Party has an invalid object type.\nExpecting: com.arsdigita.kernel.Party\nActual: " + party.getObjectType().getQualifiedName(), e);
        }
        DataQuery query = impliedPrivs ? this.getQuery("PrivilegesForParty") : this.getQuery("ImpliedPrivilegesForParty");
        query.setParameter("objectID", object.get("id"));
        query.setParameter("partyID", party.get("id"));
        HashSet<PrivilegeDescriptor> set = new HashSet<PrivilegeDescriptor>();
        while (query.next()) {
            set.add(PrivilegeDescriptor.get((String)query.get("privilege")));
        }
        query.close();
        return set;
    }

    private OID createPermissionOID(PermissionDescriptor permission) {
        OID oid = new OID("com.arsdigita.kernel.permissions.Permission");
        oid.set("objectId", permission.getACSObjectOID().get("id"));
        oid.set("partyId", permission.getPartyOID().get("id"));
        oid.set("privilege", permission.getPrivilegeDescriptor().getName());
        return oid;
    }

    private DataQuery getQuery(String queryName) {
        return SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.permissions." + queryName);
    }

    private OID getPublicPartyOID() {
        return new OID("com.arsdigita.kernel.User", -200);
    }

    public static Collection constructAccessList(OID partyOID) {
        ArrayList<BigDecimal> users = new ArrayList<BigDecimal>();
        BigDecimal partyId = (BigDecimal)partyOID.get("id");
        if (partyId.equals(new BigDecimal(-200.0))) {
            users.add(new BigDecimal(-200.0));
        } else {
            users.add(new BigDecimal(-200.0));
            users.add(partyId);
            users.add(new BigDecimal(-202.0));
        }
        return users;
    }

    public OID checkOID(OID oid) {
        if (oid == null) {
            oid = this.getPublicPartyOID();
        }
        return oid;
    }
}

