/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainService;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionException;
import com.arsdigita.kernel.permissions.PermissionManager;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PermissionService
extends DomainService {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PermissionService.java#21 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$permissions$PermissionService == null ? (class$com$arsdigita$kernel$permissions$PermissionService = PermissionService.class$("com.arsdigita.kernel.permissions.PermissionService")) : class$com$arsdigita$kernel$permissions$PermissionService));
    private static PermissionManager s_manager = null;
    private static boolean s_enabled = true;
    static /* synthetic */ Class class$com$arsdigita$kernel$permissions$PermissionService;

    private static PermissionManager getPermissionManager() {
        if (s_manager == null) {
            s_manager = new PermissionManager();
        }
        return s_manager;
    }

    public static void setPermissionManager(PermissionManager manager) {
        s_manager = manager == null ? new PermissionManager() : manager;
    }

    public static final boolean isEnabled() {
        return s_enabled;
    }

    public static final void setEnabled(boolean value) {
        s_enabled = value;
    }

    public static void assertPermission(PermissionDescriptor permission) {
        if (!PermissionService.isEnabled()) {
            return;
        }
        if (!PermissionService.checkPermission(permission)) {
            throw new PermissionException(permission);
        }
    }

    public static boolean checkPermission(PermissionDescriptor permission) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("checking " + permission.getPrivilegeDescriptor() + " on " + permission.getACSObjectOID() + " for " + permission.getPartyOID()));
        }
        return PermissionService.getPermissionManager().checkPermission(permission);
    }

    public static boolean checkDirectPermission(PermissionDescriptor permission) {
        return PermissionService.getPermissionManager().checkDirectPermission(permission);
    }

    public static void grantPermission(PermissionDescriptor permission) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("granting " + permission.getPrivilegeDescriptor() + " on " + permission.getACSObjectOID() + " for " + permission.getPartyOID()));
        }
        PermissionService.getPermissionManager().grantPermission(permission);
    }

    public static void revokePermission(PermissionDescriptor permission) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("revoking " + permission.getPrivilegeDescriptor() + " on " + permission.getACSObjectOID() + " for " + permission.getPartyOID()));
        }
        PermissionService.getPermissionManager().revokePermission(permission);
    }

    public static DataObject getContext(OID oid) {
        return PermissionService.getPermissionManager().getContext(oid);
    }

    public static DataObject getContext(ACSObject acsObject) {
        return PermissionService.getPermissionManager().getContext(acsObject);
    }

    public static void setContext(ACSObject acsObject, ACSObject context) throws PersistenceException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting context of " + acsObject + " to " + context));
        }
        PermissionService.getPermissionManager().setContext(acsObject, context);
    }

    public static void setContext(OID acsObjectOID, OID contextOID) throws PersistenceException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting context of " + acsObjectOID + " to " + contextOID));
        }
        PermissionService.getPermissionManager().setContext(acsObjectOID, contextOID);
    }

    public static void clonePermissions(ACSObject acsObject) throws PersistenceException {
        PermissionService.getPermissionManager().clonePermissions(acsObject);
    }

    public static void clonePermissions(OID acsObjectOID) throws PersistenceException {
        PermissionService.getPermissionManager().clonePermissions(acsObjectOID);
    }

    public static ObjectPermissionCollection getGrantedPermissions(OID acsObjectOID) {
        return PermissionService.getPermissionManager().getGrantedPermissions(acsObjectOID);
    }

    public static ObjectPermissionCollection getDirectGrantedPermissions(OID acsObjectOID) {
        PermissionService.checkType(acsObjectOID, "com.arsdigita.kernel.ACSObject");
        DataQuery query = PermissionService.getQuery("ObjectDirectPermissionCollection");
        query.setParameter("objectID", acsObjectOID.get("id"));
        query.addOrder("granteeID");
        query.addOrder("privilege");
        return new ObjectPermissionCollection(query);
    }

    public static ObjectPermissionCollection getGrantedUniversalPermissions() {
        return PermissionService.getPermissionManager().getGrantedUniversalPermissions();
    }

    public static void filterObjects(DataCollection dataCollection, PrivilegeDescriptor privilege, OID userOID) {
        PermissionService.getPermissionManager().filterObjects(dataCollection, privilege, userOID);
    }

    public static void filterObjects(DomainCollection domainCollection, PrivilegeDescriptor privilege, OID userOID) {
        if (!PermissionService.isEnabled()) {
            return;
        }
        PermissionService.filterObjects(PermissionService.getDataCollection(domainCollection), privilege, userOID);
    }

    public static void filterQuery(DataQuery dataQuery, String propertyName, PrivilegeDescriptor privilege, OID userOID) {
        if (!PermissionService.isEnabled()) {
            return;
        }
        Filter f = PermissionService.getFilterQuery(dataQuery.getFilterFactory(), propertyName, privilege, userOID);
        dataQuery.addFilter(f);
    }

    public static void objectFilterQuery(DataQuery dataQuery, String propertyName, PrivilegeDescriptor privilege, OID objectOID) {
        if (!PermissionService.isEnabled()) {
            return;
        }
        Filter f = PermissionService.getObjectFilterQuery(dataQuery.getFilterFactory(), propertyName, privilege, objectOID);
        dataQuery.addFilter(f);
    }

    public static Filter getFilterQuery(FilterFactory factory, String propertyName, PrivilegeDescriptor privilege, OID partyOID) {
        return PermissionService.getPermissionManager().getFilterQuery(factory, propertyName, privilege, partyOID);
    }

    public static Filter getObjectFilterQuery(FilterFactory factory, String propertyName, PrivilegeDescriptor privilege, OID oid) {
        return PermissionService.getPermissionManager().getObjectFilterQuery(factory, propertyName, privilege, oid);
    }

    public static Iterator getDirectPrivileges(OID object, OID party) {
        PermissionService.checkType(object, "com.arsdigita.kernel.ACSObject");
        PermissionService.checkType(party, "com.arsdigita.kernel.Party");
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.kernel.permissions.Permission");
        dc.addEqualsFilter("objectId", object.get("id"));
        dc.addEqualsFilter("partyId", party.get("id"));
        ArrayList<PrivilegeDescriptor> privs = new ArrayList<PrivilegeDescriptor>();
        while (dc.next()) {
            privs.add(PrivilegeDescriptor.get((String)dc.get("privilege")));
        }
        dc.close();
        return privs.iterator();
    }

    public static Iterator getPrivileges(OID object, OID party) {
        return PermissionService.getPermissionManager().getPrivileges(object, party);
    }

    public static Iterator getImpliedPrivileges(OID object, OID party) {
        return PermissionService.getPermissionManager().getImpliedPrivileges(object, party);
    }

    public static void revokePartyPermissions(OID partyOID) {
        DataOperation revoke = PermissionService.getDataOperation("RevokePartyPermissions");
        revoke.setParameter("partyID", partyOID.get("id"));
        revoke.execute();
    }

    private static void checkType(OID objectOID, String baseTypeName) {
        try {
            ObjectType.verifySubtype(baseTypeName, objectOID.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID has an invalid object type.\nExpected: " + baseTypeName + "\nActual: " + objectOID.getObjectType().getQualifiedName(), e);
        }
    }

    private static DataOperation getDataOperation(String opName) {
        return SessionManager.getSession().retrieveDataOperation("com.arsdigita.kernel.permissions." + opName);
    }

    private static DataQuery getQuery(String queryName) {
        return SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.permissions." + queryName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

