/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.UserAuthentication;
import com.arsdigita.kernel.security.AccountNotFoundException;
import com.arsdigita.kernel.security.PasswordLoginModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class LocalLoginModule
extends PasswordLoginModule {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/LocalLoginModule.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$security$LocalLoginModule == null ? (class$com$arsdigita$kernel$security$LocalLoginModule = LocalLoginModule.class$("com.arsdigita.kernel.security.LocalLoginModule")) : class$com$arsdigita$kernel$security$LocalLoginModule).getName());
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$LocalLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        super.initialize(subject, handler, shared, options);
        this.m_handler = handler;
        this.m_subject = subject;
        this.m_shared = shared;
        this.m_options = options;
    }

    protected void checkPassword(String username, char[] password) throws LoginException {
        UserAuthentication auth;
        s_log.debug((Object)"START checkPassword");
        try {
            s_log.debug((Object)"retreiving UserAuthentication");
            auth = UserAuthentication.retrieveForLoginName(username);
        }
        catch (DataObjectNotFoundException e) {
            throw new AccountNotFoundException("no such user: " + username, e);
        }
        s_log.debug((Object)"checking password");
        if (!auth.isValidPassword(new String(password))) {
            s_log.debug((Object)"FAILURE checkPassword: bad password");
            throw new FailedLoginException("bad username/password");
        }
        s_log.debug((Object)"SUCCESS checkPassword");
    }

    public boolean commit() throws LoginException {
        s_log.debug((Object)"commit");
        return true;
    }

    public boolean abort() throws LoginException {
        s_log.debug((Object)"abort");
        return true;
    }

    public boolean logout() throws LoginException {
        s_log.debug((Object)"logout");
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

