/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.KernelLoginException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public class LoginContext {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$security$LoginContext == null ? (class$com$arsdigita$kernel$security$LoginContext = LoginContext.class$("com.arsdigita.kernel.security.LoginContext")) : class$com$arsdigita$kernel$security$LoginContext));
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/LoginContext.java#11 $ by $Author: mbooth $, $DateTime: 2004/07/12 12:21:48 $";
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared = new HashMap();
    private LoginModule[] m_modules;
    private AppConfigurationEntry.LoginModuleControlFlag[] m_flags;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$LoginContext;

    public LoginContext(String name) throws LoginException {
        this(name, new Subject());
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this(name, subject, new CallbackHandler(){

            public void handle(Callback[] cbs) throws UnsupportedCallbackException {
                if (cbs.length > 0) {
                    throw new UnsupportedCallbackException(cbs[0], "CallbackHandler not defined");
                }
            }
        });
    }

    public LoginContext(String name, CallbackHandler handler) throws LoginException {
        this(name, new Subject(), handler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler handler) throws LoginException {
        this.m_subject = subject;
        this.m_handler = handler;
        Configuration config = Configuration.getConfiguration();
        if (config == null) {
            throw new LoginException("Login config not defined");
        }
        AppConfigurationEntry[] entries = config.getAppConfigurationEntry(name);
        if (entries == null) {
            throw new LoginException("Login config for '" + name + "' not defined");
        }
        this.m_modules = new LoginModule[entries.length];
        this.m_flags = new AppConfigurationEntry.LoginModuleControlFlag[entries.length];
        for (int i = 0; i < this.m_modules.length; ++i) {
            String module = entries[i].getLoginModuleName();
            try {
                this.m_modules[i] = (LoginModule)Class.forName(module).newInstance();
                this.m_modules[i].initialize(this.m_subject, this.m_handler, this.m_shared, entries[i].getOptions());
                this.m_flags[i] = entries[i].getControlFlag();
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new KernelLoginException(module + " not found", e);
            }
            catch (ExceptionInInitializerError e) {
                throw new KernelLoginException(module + " initializer error", e);
            }
            catch (LinkageError e) {
                throw new KernelLoginException(module + " linkage error", e);
            }
            catch (IllegalAccessException e) {
                throw new KernelLoginException(module + " illegal access: " + "requires public no-argument constructor", e);
            }
            catch (InstantiationException e) {
                throw new KernelLoginException(module + " instantiation exception: " + "requires public no-argument constructor", e);
            }
            catch (SecurityException e) {
                throw new KernelLoginException(module + " security exception: check permissions", e);
            }
            catch (ClassCastException e) {
                throw new KernelLoginException(module + " not a LoginModule", e);
            }
        }
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public void login() throws LoginException {
        int i;
        LoginException first = null;
        boolean gotFailure = false;
        for (i = 0; i < this.m_modules.length; ++i) {
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Login on " + this.m_modules[i].getClass().getName()));
                }
                this.m_modules[i].login();
                s_log.debug((Object)"Login succeeded");
                if (this.m_flags[i] != AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) continue;
            }
            catch (LoginException e) {
                if (first == null) {
                    first = e;
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Login failed: " + this.m_flags[i]), (Throwable)e);
                }
                if (this.m_flags[i] == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    gotFailure = true;
                    continue;
                }
                if (this.m_flags[i] != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) continue;
                gotFailure = true;
            }
            break;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("gotFailure: " + gotFailure));
        }
        if (!gotFailure) {
            first = null;
            s_log.debug((Object)"Doing commit");
            for (i = 0; i < this.m_modules.length; ++i) {
                try {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Commit on " + this.m_modules[i].getClass().getName()));
                    }
                    this.m_modules[i].commit();
                    s_log.debug((Object)"Commit succeeded");
                    continue;
                }
                catch (LoginException e) {
                    s_log.debug((Object)"Commit failed", (Throwable)e);
                    gotFailure = true;
                    if (first != null) continue;
                    first = e;
                }
            }
            if (!gotFailure) {
                return;
            }
        }
        s_log.debug((Object)"Doing abort");
        for (i = 0; i < this.m_modules.length; ++i) {
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Abort on " + this.m_modules[i].getClass().getName()));
                }
                this.m_modules[i].abort();
                s_log.debug((Object)"Abort succeeded");
                continue;
            }
            catch (LoginException e) {
                s_log.debug((Object)"Abort failed", (Throwable)e);
                gotFailure = true;
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    public void logout() throws LoginException {
        LoginException first = null;
        for (int i = 0; i < this.m_modules.length; ++i) {
            try {
                this.m_modules[i].logout();
                continue;
            }
            catch (LoginException e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

