/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.dispatcher.DispatcherHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SecurityLogger {
    public static final String versionId = "";
    private static final Logger s_log = Logger.getLogger((String)"SECURITY");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private SecurityLogger() {
    }

    private static StringBuffer appendTimestamp(StringBuffer buf) {
        return buf.append(DATE_FORMAT.format(new Date()));
    }

    private static StringBuffer appendIP(StringBuffer buf) {
        HttpServletRequest req = DispatcherHelper.getRequest();
        if (req == null) {
            return buf.append("no-IP-available");
        }
        return buf.append(req.getRemoteAddr());
    }

    public static void log(Priority p, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        SecurityLogger.appendTimestamp(buf).append(' ');
        SecurityLogger.appendIP(buf).append(' ').append(message.toString());
        s_log.log(p, (Object)buf.toString(), t);
    }

    public static void log(Priority p, Object message) {
        StringBuffer buf = new StringBuffer();
        SecurityLogger.appendTimestamp(buf).append(' ');
        SecurityLogger.appendIP(buf).append(' ').append(message.toString());
        s_log.log(p, (Object)buf.toString());
    }

    public static void debug(Object message) {
        SecurityLogger.log(Priority.DEBUG, message, null);
    }

    public static void debug(Object message, Throwable t) {
        SecurityLogger.log(Priority.DEBUG, message, t);
    }

    public static void info(Object message) {
        SecurityLogger.log(Priority.INFO, message, null);
    }

    public static void info(Object message, Throwable t) {
        SecurityLogger.log(Priority.INFO, message, t);
    }

    public static void warn(Object message) {
        SecurityLogger.log(Priority.WARN, message, null);
    }

    public static void warn(Object message, Throwable t) {
        SecurityLogger.log(Priority.WARN, message, t);
    }

    public static void error(Object message) {
        SecurityLogger.log(Priority.ERROR, message, null);
    }

    public static void error(Object message, Throwable t) {
        SecurityLogger.log(Priority.ERROR, message, t);
    }

    public static void fatal(Object message) {
        SecurityLogger.log(Priority.FATAL, message, null);
    }

    public static void fatal(Object message, Throwable t) {
        SecurityLogger.log(Priority.FATAL, message, t);
    }
}

