/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.Globalized;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.math.BigDecimal;

public class BasicResourceConfigFormSection
extends ResourceConfigFormSection
implements Globalized {
    private BigDecimal m_resourceTypeID;
    private RequestLocal m_parentResourceRL;
    private final RequestLocal m_resourceRL;
    private TextField m_titleEntry;
    private TextArea m_descriptionEntry;

    public BasicResourceConfigFormSection(ResourceType resType, RequestLocal parentResourceRL) {
        Assert.assertNotNull(resType, "resType may not be null");
        Assert.assertNotNull(parentResourceRL, "parentResourceRL may not be null");
        this.m_resourceRL = null;
        this.setup();
        this.m_parentResourceRL = parentResourceRL;
        this.m_resourceTypeID = resType.getID();
        this.m_titleEntry.setDefaultValue(resType.getTitle());
    }

    public BasicResourceConfigFormSection(RequestLocal resource) {
        Assert.assertNotNull(resource);
        this.m_resourceRL = resource;
        this.setup();
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Resource app = (Resource)BasicResourceConfigFormSection.this.m_resourceRL.get(ps);
                BasicResourceConfigFormSection.this.initialize(ps, app);
            }
        });
    }

    private void setup() {
        this.add(new Label(new GlobalizedMessage("kernel.title", "com.arsdigita.kernel/ui/KernelResources")));
        this.m_titleEntry = new TextField("title");
        this.m_titleEntry.addValidationListener(new NotEmptyValidationListener("Title is required"));
        this.m_titleEntry.setSize(20);
        this.add(this.m_titleEntry);
        this.add(new Label(new GlobalizedMessage("kernel.description", "com.arsdigita.kernel/ui/KernelResources")));
        this.m_descriptionEntry = new TextArea("desc");
        this.m_descriptionEntry.setRows(5);
        this.m_descriptionEntry.setCols(40);
        this.add(this.m_descriptionEntry);
    }

    public String getTitle(PageState ps) {
        return (String)this.m_titleEntry.getValue(ps);
    }

    public String getDescription(PageState ps) {
        return (String)this.m_descriptionEntry.getValue(ps);
    }

    private void initialize(PageState ps, Resource app) {
        this.m_titleEntry.setValue(ps, app.getTitle());
        this.m_descriptionEntry.setValue(ps, app.getDescription());
    }

    public Resource createResource(PageState ps) {
        Resource result;
        Assert.assertNotNull(this.m_resourceTypeID, "BigDecimal m_resourceTypeID");
        Assert.assertNotNull(this.m_parentResourceRL, "RequestLocal m_parentResourceRL");
        ResourceType at = ResourceType.retrieveResourceType(this.m_resourceTypeID);
        String title = this.getTitle(ps);
        String description = this.getDescription(ps);
        Resource parent = this.getParent(ps);
        String resourceObjectTypeName = at.getResourceObjectType();
        ObjectType resourceObjectType = SessionManager.getMetadataRoot().getObjectType(resourceObjectTypeName);
        if (resourceObjectType.isSubtypeOf("com.arsdigita.web.Application")) {
            String urlName = this.getUrlName(ps);
            result = Application.createApplication(resourceObjectTypeName, urlName, title, (Application)parent);
        } else {
            result = Resource.createResource(at, title, parent);
        }
        result.setDescription(description);
        return result;
    }

    public Resource getParent(PageState ps) {
        Resource parent = (Resource)this.m_parentResourceRL.get(ps);
        return parent;
    }

    public String getUrlName(PageState ps) {
        String title = this.getTitle(ps);
        char[] chars = title.toCharArray();
        StringBuffer urlNameBuffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                urlNameBuffer.append(c);
                continue;
            }
            if (c != ' ') continue;
            urlNameBuffer.append('-');
        }
        String urlName = urlNameBuffer.toString();
        return urlName;
    }

    public void modifyResource(PageState ps) {
        Resource resource = (Resource)this.m_resourceRL.get(ps);
        resource.setTitle(this.getTitle(ps));
        resource.setDescription(this.getDescription(ps));
    }
}

