/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.loader;

import com.arsdigita.installer.SQLLoader;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.runtime.AbstractScript;
import com.arsdigita.runtime.InteractiveParameterLoader;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.config.JavaPropertyLoader;
import com.arsdigita.util.parameter.CompoundParameterLoader;
import com.arsdigita.util.parameter.ParameterLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class PackageLoader
extends AbstractScript {
    public static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$loader$PackageLoader == null ? (class$com$arsdigita$loader$PackageLoader = PackageLoader.class$("com.arsdigita.loader.PackageLoader")) : class$com$arsdigita$loader$PackageLoader));
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/loader/PackageLoader.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$loader$PackageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(Connection conn, String table) {
        boolean bl;
        DatabaseMetaData md = conn.getMetaData();
        if (md.storesLowerCaseIdentifiers()) {
            table = table.toLowerCase();
        } else if (md.storesUpperCaseIdentifiers()) {
            table = table.toUpperCase();
        }
        ResultSet tables = md.getTables(null, null, table, new String[]{"TABLE"});
        try {
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                tables.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
        }
        tables.close();
        return bl;
    }

    public static void requires(Connection conn, String table) {
        if (!PackageLoader.exists(conn, table)) {
            throw new IllegalStateException("table required: " + table);
        }
    }

    public static boolean exists(Session ssn, OID oid) {
        return ssn.retrieve(oid) != null;
    }

    public static void requires(Session ssn, OID oid) {
        if (!PackageLoader.exists(ssn, oid)) {
            throw new IllegalStateException("oid required: " + oid);
        }
    }

    public static boolean exists(Session ssn, String type) {
        return ssn.getMetadataRoot().getObjectType(type) != null;
    }

    public static void requires(Session ssn, String type) {
        if (!PackageLoader.exists(ssn, type)) {
            throw new IllegalStateException("type required: " + type);
        }
    }

    public static void load(Connection conn, String script) {
        SQLLoader loader = new SQLLoader(conn){

            protected Reader open(String name) {
                ClassLoader cload = this.getClass().getClassLoader();
                InputStream is = cload.getResourceAsStream(name);
                if (is == null) {
                    return null;
                }
                s_log.info((Object)("Loading: " + name));
                return new InputStreamReader(is);
            }
        };
        loader.load(script);
        s_log.info((Object)"Loading: Done");
    }

    public static ParameterLoader loader(String[] args) {
        CompoundParameterLoader result = new CompoundParameterLoader();
        result.add(new JavaPropertyLoader(PackageLoader.props(args)));
        result.add(new InteractiveParameterLoader(System.in, System.out));
        return result;
    }

    private static Properties props(String[] args) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(baos);
            for (int i = 0; i < args.length; ++i) {
                w.write(args[i]);
                w.write("\n");
            }
            ((Writer)w).flush();
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(baos.toByteArray()));
            return props;
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

