/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.logging;

import com.arsdigita.logging.ErrorReportAppender;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Exceptions;
import com.arsdigita.util.JavaPropertyReader;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.StringParameter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Collator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class ErrorReport {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/logging/ErrorReport.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$logging$ErrorReport == null ? (class$com$arsdigita$logging$ErrorReport = ErrorReport.class$("com.arsdigita.logging.ErrorReport")) : class$com$arsdigita$logging$ErrorReport));
    private Throwable[] m_throwables;
    private String m_guruMeditationCode;
    private HashMap m_sections;
    static /* synthetic */ Class class$com$arsdigita$logging$ErrorReport;

    public static void initializeAppender(String directory) {
        Assert.assertNotNull(directory, "directory is null");
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdir();
        }
        ErrorReportAppender appender = new ErrorReportAppender(directory);
        s_log.addAppender((Appender)appender);
    }

    public ErrorReport(Throwable throwable) {
        try {
            this.m_throwables = Exceptions.unwrap(throwable);
        }
        catch (Exception e) {
            s_log.error((Object)"Cannot unwrap throwable: ", (Throwable)e);
            this.m_throwables = new Throwable[]{throwable};
        }
        this.m_sections = new HashMap();
        this.addSystemProperties();
        this.addStackTrace();
    }

    public String getHostname() {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localhost == null ? "localhost" : localhost.getHostAddress();
    }

    public String getGuruMeditationCode() {
        if (this.m_guruMeditationCode == null) {
            this.m_guruMeditationCode = this.getHostname() + ":" + Integer.toHexString(Thread.currentThread().hashCode()) + ":" + Long.toHexString(System.currentTimeMillis());
        }
        return this.m_guruMeditationCode;
    }

    public void addSection(String name, Collection lines) {
        this.m_sections.put(name, lines);
    }

    public void addSection(String name, String[] lines) {
        this.m_sections.put(name, lines);
    }

    public void addSection(String name, String line) {
        this.m_sections.put(name, line);
    }

    public String getReport() {
        StringBuffer log = new StringBuffer("\n");
        log.append("-*-*-*-*-*- Begin Error Report -*-*-*-*-*-\n");
        log.append("-*-*-*- ACS Error Report Code: " + this.getGuruMeditationCode() + " -*-*-*-\n");
        for (int i = 0; i < this.m_throwables.length; ++i) {
            log.append("-*-*-*- Message " + (i + 1) + ": " + this.m_throwables[i].getClass().getName() + ": " + this.m_throwables[i].getMessage() + " -*-*-*-\n");
        }
        Iterator sections = this.m_sections.keySet().iterator();
        while (sections.hasNext()) {
            String[] lines;
            String key = (String)sections.next();
            Object val = this.m_sections.get(key);
            log.append("\n-*-*-*- Section: " + key + " -*-*-*-\n");
            if (val instanceof Collection) {
                lines = ((Collection)val).iterator();
                while (lines.hasNext()) {
                    String line = (String)lines.next();
                    log.append(line.toString() + "\n");
                }
                continue;
            }
            if (val instanceof String) {
                String line = (String)val;
                log.append(line + "\n");
                continue;
            }
            if (!(val instanceof String[])) continue;
            lines = (String[])val;
            for (int i = 0; i < lines.length; ++i) {
                log.append(lines[i] + "\n");
            }
        }
        log.append("-*-*-*-*-*- End Error Report -*-*-*-*-*-\n");
        return log.toString();
    }

    public String toString() {
        return this.getReport();
    }

    public void logit() {
        s_log.fatal((Object)this);
    }

    private void addStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.m_throwables[this.m_throwables.length - 1].printStackTrace(printWriter);
        this.addSection("Stack trace", stringWriter.toString());
    }

    private void addSystemProperties() {
        TreeSet<Object> data = new TreeSet<Object>(Collator.getInstance());
        Enumeration<Object> props = System.getProperties().keys();
        while (props.hasMoreElements()) {
            String key = (String)props.nextElement();
            String value = System.getProperty(key);
            data.add(key + ": " + value);
        }
        this.addSection("System properties", data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JavaPropertyReader reader = new JavaPropertyReader(System.getProperties());
        StringParameter param = new StringParameter("waf.logging.error_report_dir", 0, null);
        ErrorList errors = new ErrorList();
        String dir = (String)param.read(reader, errors);
        errors.check();
        if (dir != null) {
            ErrorReport.initializeAppender(dir);
        }
    }
}

