/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private byte[] m_data;
    private String m_type;
    private String m_name;

    public ByteArrayDataSource(InputStream is, String type, String name) {
        this.m_type = type;
        this.m_name = name;
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.m_data = os.toByteArray();
        }
        catch (IOException ioex) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(byte[] data, String type, String name) {
        this.m_data = data;
        this.m_type = type;
        this.m_name = name;
    }

    public ByteArrayDataSource(String data, String type, String name) {
        this(data, type, name, "iso-8859-1");
    }

    public ByteArrayDataSource(String data, String type, String name, String charset) {
        this.m_type = type;
        this.m_name = name;
        try {
            this.m_data = data.getBytes(charset);
        }
        catch (UnsupportedEncodingException uex) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.m_data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("not implemented");
    }

    public String getContentType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }
}

