/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mail;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.URLParameter;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public final class MailConfig
extends AbstractConfig {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mail/MailConfig.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Properties m_props;
    private final Parameter m_debug = new BooleanParameter("waf.mail.debug", 0, Boolean.FALSE);
    private final Parameter m_javamail = new PropertyFileParameter("waf.mail.javamail.configuration", 0, null);

    public MailConfig() {
        this.register(this.m_javamail);
        this.register(this.m_debug);
        this.loadInfo();
    }

    public Properties getJavamail() {
        if (this.m_props == null) {
            URL propsFile = (URL)this.get(this.m_javamail);
            if (propsFile == null) {
                this.m_props = new Properties();
                this.m_props.put("mail.transport.protocol", "smtp");
                this.m_props.put("mail.smtp.host", "localhost");
            } else {
                try {
                    this.m_props = PropertyFileParameter.getProperties(propsFile);
                }
                catch (IOException ioe) {
                    throw new UncheckedWrapperException("unable to retrieve properties file from " + propsFile, ioe);
                }
            }
        }
        return this.m_props;
    }

    public boolean isDebug() {
        return this.get(this.m_debug).equals(Boolean.TRUE);
    }

    private static class PropertyFileParameter
    extends URLParameter {
        PropertyFileParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
        }

        protected void doValidate(Object value, ErrorList errors) {
            super.doValidate(value, errors);
            if (!errors.isEmpty()) {
                return;
            }
            try {
                PropertyFileParameter.getProperties((URL)value);
            }
            catch (IOException ioe) {
                errors.add(new ParameterError((Parameter)this, ioe));
            }
        }

        public static Properties getProperties(URL url) throws IOException {
            Properties props = new Properties();
            props.load(url.openStream());
            return props;
        }
    }
}

