/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mail;

import com.arsdigita.mail.Mail;
import com.arsdigita.mail.ServerModes;
import com.arsdigita.mail.SocketHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class SimpleServer
extends Thread
implements ServerModes {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mail$SimpleServer == null ? (class$com$arsdigita$mail$SimpleServer = SimpleServer.class$("com.arsdigita.mail.SimpleServer")) : class$com$arsdigita$mail$SimpleServer));
    private ServerSocket m_server;
    private int m_mode;
    private static int s_success_count = 0;
    private static int s_received_count = 0;
    private static String s_soHost = "localhost";
    private static int s_soPort = 5000;
    private static int s_soTimeout = System.getProperty("os.name").equals("Linux") ? 1000 : 0;
    private static int s_soRetryDelay = 200;
    private static final int MAX_SERVERS = 10;
    private static SimpleServer[] server = new SimpleServer[10];
    private static final String help = "Try changing the value of soPort in the mail initializer.\nNote that SimpleServer requires 10 contiguous free ports\nstarting from the value of soPort.";
    private static boolean s_init = false;
    static /* synthetic */ Class class$com$arsdigita$mail$SimpleServer;

    public static synchronized int getSuccessCount() {
        return s_success_count;
    }

    static synchronized void incrSuccessCount() {
        ++s_success_count;
    }

    public static synchronized int getReceivedCount() {
        return s_received_count;
    }

    static synchronized void incrReceivedCount() {
        ++s_received_count;
    }

    public static void reset() {
        s_success_count = 0;
        s_received_count = 0;
    }

    static synchronized void setSoHost(String host) {
        s_soHost = host;
    }

    static synchronized String getSoHost() {
        return s_soHost;
    }

    static synchronized void setSoPort(int port) {
        s_soPort = port;
    }

    static synchronized int getSoPort() {
        return s_soPort;
    }

    static synchronized void setSoTimeout(int msec) {
        s_soTimeout = msec;
    }

    static synchronized int getSoTimeout() {
        return s_soTimeout;
    }

    static synchronized void setSoRetryDelay(int msec) {
        s_soRetryDelay = msec;
    }

    static synchronized int getSoRetryDelay() {
        return s_soRetryDelay;
    }

    public static synchronized void startup() {
        if (!s_init) {
            for (int i = 0; i < 10; ++i) {
                int mode = i;
                int port = i + s_soPort;
                try {
                    SimpleServer.server[i] = new SimpleServer(port, mode);
                    server[i].setDaemon(true);
                    server[i].start();
                    continue;
                }
                catch (BindException ex) {
                    s_log.error((Object)("Unable to bind to port " + port), (Throwable)ex);
                    s_log.error((Object)help);
                    return;
                }
            }
            s_init = true;
        }
        SimpleServer.setMode(0);
    }

    public static void setMode(int mode) {
        int port = s_soPort + mode;
        Mail.setSmtpServer(s_soHost, Integer.toString(port));
    }

    SimpleServer(int port, int mode) throws BindException {
        this.m_mode = mode;
        try {
            this.m_server = new ServerSocket(port);
            this.m_server.setSoTimeout(s_soTimeout);
        }
        catch (IOException ex) {
            throw new BindException("port: " + port);
        }
        s_log.debug((Object)("SimpleServer: ready on port " + port + " in mode " + mode));
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.m_server.accept();
                    SocketHandler handler = new SocketHandler(socket, this.m_mode);
                    handler.start();
                }
            }
            catch (SocketException e) {
                continue;
            }
            catch (InterruptedIOException iex) {
                continue;
            }
            catch (IOException iex) {
                iex.printStackTrace();
                continue;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

