/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.metadata;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.Sequences;
import com.arsdigita.initializer.Startup;
import com.arsdigita.metadata.DynamicElement;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.persistence.metadata.SimpleType;
import com.arsdigita.persistence.metadata.Utilities;
import com.arsdigita.util.StringUtils;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.metadata.Value;
import com.redhat.persistence.pdl.PDLWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicObjectType
extends DynamicElement {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/metadata/DynamicObjectType.java#23 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final int COLLECTION = 2;
    private static final int NULLABLE = 0;
    private static final int REQUIRED = 1;
    private com.redhat.persistence.metadata.ObjectType m_objectType;
    private ObjectMap m_objectMap;
    private static final String objectTypeString = "com.arsdigita.persistence.DynamicObjectType";
    private Root m_root = SessionManager.getSession().getMetadataRoot().getRoot();
    private DataObject m_dataObject;
    private Table m_table = null;
    private boolean m_isNew = true;
    private Collection m_mappingTables = new ArrayList();
    private Collection m_columns = new ArrayList();
    private boolean m_generateTable = false;
    private Map m_defaultValueMap = new HashMap();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$metadata$DynamicObjectType == null ? (class$com$arsdigita$metadata$DynamicObjectType = DynamicObjectType.class$("com.arsdigita.metadata.DynamicObjectType")) : class$com$arsdigita$metadata$DynamicObjectType));
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Connection m_conn = null;
    static /* synthetic */ Class class$com$arsdigita$metadata$DynamicObjectType;

    public DynamicObjectType(String name, ObjectType supertype) {
        this(name, supertype, supertype.getModel());
    }

    public DynamicObjectType(String name, ObjectType supertype, com.arsdigita.persistence.metadata.Model model) {
        if (!StringUtils.isAlphaNumeric(name)) {
            throw new PersistenceException("The name of the DynamicObjectType must be alphanumeric. You tried to create it using [" + name + "]");
        }
        if (model == null) {
            model = supertype.getModel();
        }
        this.m_objectType = new com.redhat.persistence.metadata.ObjectType(Model.getInstance(model.getName()), name, DynamicObjectType.type(supertype));
        this.m_objectMap = new ObjectMap(this.m_objectType);
        this.m_root.addObjectType(this.m_objectType);
        this.m_root.addObjectMap(this.m_objectMap);
        this.m_table = new Table(DynamicObjectType.generateTableName(this.m_objectType));
        this.m_root.addTable(this.m_table);
        this.m_generateTable = true;
        this.m_objectMap.setTable(this.m_table);
        String columnName = this.m_objectType.getName() + "_id";
        ObjectMap sm = this.m_objectMap.getSuperMap();
        if (sm == null) {
            Column col = new Column(columnName, 4, 32);
            this.m_table.addColumn(col);
            UniqueKey key = new UniqueKey(null, col);
            this.m_table.setPrimaryKey(key);
            Role role = new Role("id", this.m_root.getObjectType("global.BigDecimal"), false, false, false);
            this.m_objectType.addProperty(role);
            this.m_objectMap.getKeyProperties().add(role);
            this.m_objectMap.addMapping(new Value(Path.get(role.getName()), col));
        } else {
            UniqueKey uk = sm.getTable().getPrimaryKey();
            ForeignKey fk = DynamicObjectType.fk(this.m_table, null, uk);
            UniqueKey key = new UniqueKey(this.m_table, null, fk.getColumns());
            this.m_table.setPrimaryKey(key);
        }
    }

    public DynamicObjectType(String typeName) {
        this(SessionManager.getMetadataRoot().getObjectType(typeName), typeName);
    }

    public DynamicObjectType(ObjectType objectType) {
        this(objectType, objectType.getQualifiedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectType(ObjectType objectType, String typeName) {
        if (objectType == null) {
            throw new PersistenceException("The Object Type you have requested (" + typeName + ") does not exist");
        }
        this.m_objectType = DynamicObjectType.type(objectType);
        this.m_objectMap = this.m_root.getObjectMap(this.m_objectType);
        DataCollection collection = SessionManager.getSession().retrieve(objectTypeString);
        collection.addEqualsFilter("dynamicType", typeName);
        try {
            if (!collection.next()) {
                throw new PersistenceException("The Object Type you have requested (" + typeName + ") cannot be used as a Dynamic Object because it " + "has been defined as read-only");
            }
            this.m_dataObject = collection.getDataObject();
        }
        finally {
            collection.close();
        }
        this.m_table = this.m_objectMap.getTable();
        this.m_isNew = false;
    }

    public boolean hasProperty(String name) {
        return this.m_objectType.hasProperty(name);
    }

    public Property addOptionalAttribute(String name, SimpleType propertyType) {
        return this.addOptionalAttribute(name, propertyType, -1);
    }

    public Property addOptionalAttribute(String name, SimpleType propertyType, int size) {
        return this.addAttribute(name, propertyType, 0, size, null);
    }

    public Property addRequiredAttribute(String name, SimpleType propertyType, Object defaultValue) {
        return this.addRequiredAttribute(name, propertyType, -1, defaultValue);
    }

    public Property addRequiredAttribute(String name, SimpleType propertyType, int size, Object defaultValue) {
        if (defaultValue == null) {
            throw new PersistenceException("In order to create a required attribute, the default value must not be null");
        }
        return this.addAttribute(name, propertyType, 1, size, defaultValue);
    }

    private Property addAttribute(String name, SimpleType propertyType, int multiplicity, int size, Object defaultValue) {
        if (!StringUtils.isAlphaNumeric(name)) {
            throw new PersistenceException("The name of the DynamicObjectType must be alphanumeric. You tried to create it using [" + name + "]");
        }
        if (this.hasProperty(name)) {
            throw new PersistenceException("The property [" + name + "] already " + "exists in this object type.");
        }
        Role role = new Role(name, this.m_root.getObjectType(propertyType.getQualifiedName()), false, multiplicity == 2, multiplicity == 0);
        this.m_objectType.addProperty(role);
        String columnName = DynamicObjectType.generateColumnName(this.m_table, name);
        if (size <= 0) {
            size = -1;
        }
        Adapter ad = this.m_root.getAdapter(propertyType.getJavaClass());
        int jdbcType = ad.defaultJDBCType();
        if (propertyType.equals(this.m_root.getObjectType("global.String")) && size > 4000) {
            jdbcType = 2005;
            size = -1;
        }
        Column col = new Column(columnName, jdbcType, size);
        col.setNullable(true);
        this.m_table.addColumn(col);
        this.m_columns.add(col);
        this.m_objectMap.addMapping(new Value(Path.get(name), col));
        if (defaultValue != null) {
            this.m_defaultValueMap.put(name, defaultValue);
        }
        return DynamicObjectType.property(role);
    }

    private Statement createStatement() throws PersistenceException {
        try {
            this.m_conn = ConnectionManager.getConnection();
            return this.m_conn.createStatement();
        }
        catch (SQLException e) {
            throw PersistenceException.newInstance("Unable to create statement: " + e.getMessage(), e);
        }
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public Property addOptionalAssociation(String name, ObjectType type) {
        return this.addAssociation(name, type, 0, null);
    }

    public Property addRequiredAssociation(String name, ObjectType type, Object defaultValue) {
        return this.addAssociation(name, type, 1, defaultValue);
    }

    public Property addCollectionAssociation(String name, ObjectType type) {
        return this.addAssociation(name, type, 2, null);
    }

    private void addColumns(Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            this.m_columns.add(cols[i]);
        }
    }

    public Property addAssociation(String name, ObjectType objType, int mult, Object defaultValue) {
        com.redhat.persistence.metadata.ObjectType type = DynamicObjectType.type(objType);
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            throw new PersistenceException("The name of the association must be alphanumeric. You tried to create it using [" + name + "]");
        }
        if (this.hasProperty(name)) {
            throw new PersistenceException("The property [" + name + "] already " + "exists in this object type.");
        }
        Role role = new Role(name, type, false, mult == 2, mult == 0);
        this.m_objectType.addProperty(role);
        if (!role.isCollection()) {
            UniqueKey key = this.m_root.getObjectMap(type).getTable().getPrimaryKey();
            ForeignKey fk = DynamicObjectType.fk(this.m_table, name, key);
            this.addColumns(fk.getColumns());
            this.m_objectMap.addMapping(new JoinTo(Path.get(name), fk));
        } else {
            Table table = new Table(DynamicObjectType.generateTableName(role));
            this.m_root.addTable(table);
            UniqueKey from = this.m_objectMap.getTable().getPrimaryKey();
            UniqueKey to = this.m_root.getObjectMap(type).getTable().getPrimaryKey();
            JoinThrough jt = new JoinThrough(Path.get(name), DynamicObjectType.fk(table, "from", from), DynamicObjectType.fk(table, "to", to));
            this.addColumns(jt.getFrom().getColumns());
            this.addColumns(jt.getTo().getColumns());
            this.m_objectMap.addMapping(jt);
            this.m_mappingTables.add(table);
        }
        if (defaultValue != null) {
            this.m_defaultValueMap.put(name, defaultValue);
        }
        return DynamicObjectType.property(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectType save() {
        Collection ddlToAdd = this.makeTableDDL();
        String pdl = this.makeObjectTypePDL();
        s_log.debug((Object)("PDL: " + pdl));
        Statement statement = this.createStatement();
        try {
            if (ddlToAdd != null) {
                String ddl = null;
                try {
                    Iterator iterator = ddlToAdd.iterator();
                    while (iterator.hasNext()) {
                        ddl = (String)iterator.next();
                        statement.executeUpdate(ddl);
                    }
                }
                catch (SQLException e) {
                    throw PersistenceException.newInstance(e.getMessage() + Utilities.LINE_BREAK + "SQL for ADD: " + ddl + Utilities.LINE_BREAK + "PDL: " + pdl, e);
                }
            }
            String mappingSQL = null;
            try {
                String[] mappingTables = this.makeMappingTablesDDL();
                for (int i = 0; i < mappingTables.length; ++i) {
                    mappingSQL = mappingTables[i];
                    s_log.debug((Object)("update: " + mappingSQL));
                    statement.executeUpdate(mappingSQL);
                }
            }
            catch (SQLException e) {
                throw PersistenceException.newInstance(e.getMessage() + Utilities.LINE_BREAK + "SQL for Mapping Table: " + mappingSQL + Utilities.LINE_BREAK + "PDL: " + pdl, e);
            }
            try {
                this.m_conn.commit();
            }
            catch (SQLException e) {
                throw PersistenceException.newInstance(e.getMessage(), e);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                if (this.m_conn != null) {
                    this.m_conn.rollback();
                    ConnectionManager.returnConnection(this.m_conn);
                }
                statement.close();
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.m_conn != null) {
                this.m_conn.rollback();
                ConnectionManager.returnConnection(this.m_conn);
            }
            statement.close();
        }
        catch (SQLException ignored) {}
        try {
            if (this.m_dataObject == null) {
                this.m_dataObject = SessionManager.getSession().create(objectTypeString);
                this.m_dataObject.set("id", Sequences.getNextValue());
                this.m_dataObject.set("objectType", objectTypeString);
                this.m_dataObject.set("dynamicType", this.m_objectType.getQualifiedName());
                this.m_dataObject.set("displayName", objectTypeString);
            }
            this.m_dataObject.set("pdlFile", pdl);
            this.m_dataObject.save();
        }
        catch (SQLException e) {
            throw PersistenceException.newInstance("Error saving PDL file", e);
        }
        this.m_isNew = false;
        this.m_mappingTables = new ArrayList();
        this.m_defaultValueMap = new HashMap();
        return DynamicObjectType.type(this.m_objectType);
    }

    public ObjectType getObjectType() {
        return DynamicObjectType.type(this.m_objectType);
    }

    public String makeObjectTypePDL() {
        StringWriter pdl = new StringWriter();
        PDLWriter w = new PDLWriter(pdl);
        w.write(this.m_objectType);
        String result = "model " + this.m_objectType.getModel().getQualifiedName() + ";" + Utilities.LINE_BREAK + pdl.toString();
        return result;
    }

    public final Collection makeTableDDL() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_generateTable) {
            result.add(this.m_table.getSQL(false));
        } else {
            Iterator it = this.m_columns.iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                result.add(col.getSQL());
            }
        }
        return result;
    }

    public final String[] makeMappingTablesDDL() {
        String[] mappingDDL;
        if (this.m_mappingTables.size() > 0) {
            mappingDDL = new String[this.m_mappingTables.size()];
            int idx = 0;
            Iterator it = this.m_mappingTables.iterator();
            while (it.hasNext()) {
                Table t = (Table)it.next();
                String sql = t.getSQL(false);
                mappingDDL[idx++] = sql;
            }
        } else {
            mappingDDL = EMPTY_STRING_ARRAY;
        }
        return mappingDDL;
    }

    public String toString() {
        String appendString = Utilities.LINE_BREAK + "The following will be " + "added to the table:" + this.makeTableDDL();
        return this.m_objectType.toString() + appendString;
    }

    public static void main(String[] args) {
        TransactionContext txn;
        Startup startup;
        block19: {
            DataObject dataObject;
            String type;
            String IMPORT = "import";
            String EXPORT = "export";
            String usageString = "Usage: java DyanmicObjectType  <[" + IMPORT + " | " + EXPORT + "]> <DynamicObjectType> " + "<FileLocation> <StartupScript> <WebAppRoot>";
            if (args.length != 5) {
                System.err.println(usageString);
                System.exit(1);
            }
            if (!(type = args[0]).equalsIgnoreCase(IMPORT) && !type.equalsIgnoreCase(EXPORT)) {
                System.err.println("The first argument must specify whether you wish to 'import' or 'export'" + Utilities.LINE_BREAK + usageString);
            }
            String objectType = args[1];
            String fileName = args[2];
            String startupScript = args[3];
            String webAppRoot = args[4];
            startup = new Startup(webAppRoot, startupScript);
            startup.setLastInitializer("com.arsdigita.persistence.Initializer");
            startup.init();
            txn = SessionManager.getSession().getTransactionContext();
            if (!txn.inTxn()) {
                txn.beginTxn();
            }
            DataCollection collection = SessionManager.getSession().retrieve(objectTypeString);
            collection.addEqualsFilter("dynamicType", objectType);
            if (collection.next()) {
                dataObject = collection.getDataObject();
            } else {
                dataObject = SessionManager.getSession().create(objectTypeString);
                try {
                    dataObject.set("id", Sequences.getNextValue());
                }
                catch (SQLException e) {
                    System.err.println("Unable to create sequence:" + Utilities.LINE_BREAK + e.getMessage());
                    txn.commitTxn();
                    System.exit(1);
                }
                dataObject.set("objectType", objectTypeString);
                dataObject.set("dynamicType", objectType);
                dataObject.set("displayName", objectType);
            }
            if (type.equalsIgnoreCase(IMPORT)) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(fileName));
                    StringBuffer pdlFile = new StringBuffer();
                    try {
                        String nextLine = reader.readLine();
                        while (nextLine != null) {
                            pdlFile.append(nextLine + Utilities.LINE_BREAK);
                            nextLine = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        String suffix = "";
                        if (!"".equals(pdlFile.toString())) {
                            suffix = "We were able read the following" + pdlFile.toString();
                        }
                        System.err.println("There was an error reading the file [" + fileName + "].  " + suffix);
                    }
                    dataObject.set("pdlFile", pdlFile.toString());
                    dataObject.save();
                }
                catch (FileNotFoundException e) {
                    System.err.println("The file you have provided to input [" + fileName + "] cannot be accessed.");
                    if (!new File(fileName).canRead()) {
                        System.err.println("The system cannot read the file");
                    }
                    txn.commitTxn();
                    System.exit(1);
                }
            } else {
                String pdlFile = (String)dataObject.get("pdlFile");
                if (pdlFile == null) {
                    System.err.println("The object type you have requested [" + objectType + "] cannot be found.  Please " + "check the type and try again.");
                    txn.commitTxn();
                    System.exit(1);
                }
                try {
                    new PrintWriter(new FileOutputStream(fileName)).print(pdlFile);
                }
                catch (FileNotFoundException e) {
                    System.err.println("The file you have provided to input [" + fileName + "] cannot be accessed.");
                    if (new File(fileName).canWrite()) break block19;
                    System.err.println("The system cannot write to the file");
                }
            }
        }
        txn.commitTxn();
        startup.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

