/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

public class MimeTypeExtension
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/MimeTypeExtension.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.MimeTypeExtension";
    public static final String MIME_TYPE = "mimeType";
    public static final String FILE_EXTENSION = "fileExtension";

    public static MimeTypeExtension create(String fileExtension, String mimeType) {
        MimeType mimeTypeObject = MimeType.loadMimeType(mimeType);
        if (mimeTypeObject == null) {
            throw new DataObjectNotFoundException("Unable to locate mime type of " + mimeType);
        }
        return MimeTypeExtension.create(fileExtension, mimeTypeObject);
    }

    public static MimeTypeExtension create(String fileExtension, MimeType mimeType) {
        MimeTypeExtension ext = new MimeTypeExtension();
        ext.setFileExtension(fileExtension);
        ext.setMimeTypeObject(mimeType);
        return ext;
    }

    public static MimeTypeExtension retrieve(String fileExtension) {
        try {
            return new MimeTypeExtension(new OID(BASE_DATA_OBJECT_TYPE, (Object)fileExtension.toLowerCase()));
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    protected MimeTypeExtension() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public MimeTypeExtension(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public MimeTypeExtension(DataObject obj) {
        super(obj);
    }

    protected MimeTypeExtension(String type) {
        super(type);
    }

    public MimeType getMimeTypeObject() {
        DataObject object = (DataObject)this.get(MIME_TYPE);
        if (object != null) {
            return new MimeType(object);
        }
        return null;
    }

    public void setMimeTypeObject(MimeType object) {
        this.set(MIME_TYPE, object);
    }

    public String getMimeType() {
        return this.getMimeTypeObject().getMimeType();
    }

    public void setMimeType(String value) {
        MimeType mimeType = MimeType.loadMimeType(value);
        this.setMimeTypeObject(mimeType);
    }

    public String getFileExtension() {
        return (String)this.get(FILE_EXTENSION);
    }

    public void setFileExtension(String value) {
        this.set(FILE_EXTENSION, value.toLowerCase());
    }
}

