/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

class Which
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Which.java#4 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$packaging$Which == null ? (class$com$arsdigita$packaging$Which = Which.class$("com.arsdigita.packaging.Which")) : class$com$arsdigita$packaging$Which));
    private static final Options OPTIONS = Which.getOptions();
    static /* synthetic */ Class class$com$arsdigita$packaging$Which;

    public Which() {
        super("which", "Find a resource or class in the CCM classpath");
    }

    private static List getClassURLs(String classname) {
        return Which.getResourceURLs(classname.replace('.', '/') + ".class");
    }

    private static List getResourceURLs(String resource) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resource);
            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
        return list;
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (line.hasOption("usage")) {
            this.usage(OPTIONS, System.out, "RESOURCES");
            return true;
        }
        String[] names = line.getArgs();
        if (names.length == 0) {
            this.usage(OPTIONS, System.err, "RESOURCES");
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Iterator classes = Which.getClassURLs(name).iterator();
            while (classes.hasNext()) {
                System.out.println(classes.next());
            }
            Iterator resources = Which.getResourceURLs(name).iterator();
            while (resources.hasNext()) {
                System.out.println(resources.next());
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

