/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.CompoundFilterImpl;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.FilterImpl;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;

class FilterFactoryImpl
implements FilterFactory {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/FilterFactoryImpl.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Session m_ssn;

    FilterFactoryImpl(Session ssn) {
        this.m_ssn = ssn;
    }

    public Filter simple(String sql) {
        return FilterImpl.simple(sql);
    }

    public Filter equals(String attribute, Object value) {
        return FilterImpl.equals(attribute, value);
    }

    public Filter notEquals(String attribute, Object value) {
        return FilterImpl.notEquals(attribute, value);
    }

    public Filter lessThan(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.lessThan(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter lessThanEquals(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.lessThanEquals(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter greaterThan(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.greaterThan(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter greaterThanEquals(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.greaterThanEquals(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter startsWith(String attribute, String value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.startsWith(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter endsWith(String attribute, String value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.endsWith(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter contains(String attribute, String value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.contains(attribute, value, trueForAllIfValueIsNull);
    }

    public Filter compare(String expressionOne, int comparator, String expressionTwo) {
        String stringComparator = null;
        boolean notEqualsValue = false;
        switch (comparator) {
            case 1: {
                stringComparator = "=";
                break;
            }
            case 2: {
                stringComparator = "!=";
                notEqualsValue = true;
                break;
            }
            case 3: {
                stringComparator = ">";
                notEqualsValue = true;
                break;
            }
            case 4: {
                stringComparator = "<";
                notEqualsValue = true;
                break;
            }
            case 5: {
                stringComparator = ">=";
                break;
            }
            case 6: {
                stringComparator = "<=";
                break;
            }
            case 7: {
                return this.simple(expressionOne + " like " + expressionTwo + " || '%'");
            }
            case 8: {
                return this.simple(expressionOne + " like '%' || " + expressionTwo);
            }
            case 9: {
                return this.simple(expressionOne + " like '%' || " + expressionTwo + " || '%'");
            }
            default: {
                throw new PersistenceException("The comparator that you have passed in is not value");
            }
        }
        String expressionOneNotNull = FilterImpl.createNullString(stringComparator, expressionOne);
        String expressionTwoNotNull = FilterImpl.createNullString(stringComparator, expressionTwo);
        if (notEqualsValue) {
            return this.simple("(" + expressionOne + " " + stringComparator + " " + expressionTwo + " or (" + expressionOneNotNull + " and not " + expressionTwoNotNull + ") or (" + expressionTwoNotNull + " and not " + expressionOneNotNull + "))");
        }
        return this.simple("(" + expressionOne + " " + stringComparator + " " + expressionTwo + " or (" + expressionOneNotNull + " and " + expressionTwoNotNull + "))");
    }

    public Filter in(String propertyName, String queryName) {
        return FilterImpl.in(this.m_ssn.getRoot(), propertyName, queryName);
    }

    public Filter in(String property, String subQueryProperty, String queryName) {
        return FilterImpl.in(this.m_ssn.getRoot(), property, subQueryProperty, queryName);
    }

    public Filter notIn(String propertyName, String queryName) {
        return FilterImpl.notIn(this.m_ssn.getRoot(), propertyName, queryName);
    }

    public CompoundFilter and() {
        return CompoundFilterImpl.and();
    }

    public CompoundFilter or() {
        return CompoundFilterImpl.or();
    }
}

