/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.metadata;

import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.metadata.CompoundType;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ObjectType
extends CompoundType {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/metadata/ObjectType.java#18 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private com.redhat.persistence.metadata.ObjectType m_type;

    static ObjectType wrap(com.redhat.persistence.metadata.ObjectType type) {
        if (type == null) {
            return null;
        }
        return new ObjectType(type);
    }

    static Collection wrap(Collection types) {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>(types.size());
        Iterator it = types.iterator();
        while (it.hasNext()) {
            result.add(ObjectType.wrap((com.redhat.persistence.metadata.ObjectType)it.next()));
        }
        return result;
    }

    private ObjectType(com.redhat.persistence.metadata.ObjectType type) {
        super(type);
        this.m_type = type;
    }

    public ObjectType getSupertype() {
        return ObjectType.wrap(this.m_type.getSupertype());
    }

    public ObjectType getBasetype() {
        return ObjectType.wrap(this.m_type.getBasetype());
    }

    public boolean isKeyProperty(Property p) {
        return this.m_type.isKeyProperty(p.getName());
    }

    public boolean isKeyProperty(String name) {
        return this.m_type.isKeyProperty(name);
    }

    public Iterator getKeyProperties() {
        return Property.wrap(this.m_type.getKeyProperties()).iterator();
    }

    public Iterator getProperties() {
        return Property.wrap(this.m_type.getProperties()).iterator();
    }

    public Iterator getDeclaredProperties() {
        return Property.wrap(this.m_type.getDeclaredProperties()).iterator();
    }

    public boolean hasProperty(String name) {
        return this.m_type.hasProperty(name);
    }

    public boolean hasDeclaredProperty(String name) {
        return this.m_type.hasDeclaredProperty(name);
    }

    public Property getProperty(String name) {
        return Property.wrap(this.m_type.getProperty(name));
    }

    public Property getDeclaredProperty(String name) {
        return Property.wrap(this.m_type.getDeclaredProperty(name));
    }

    public boolean isSubtypeOf(String qualifiedName) {
        return this.m_type.isSubtypeOf(qualifiedName);
    }

    public boolean isSubtypeOf(ObjectType type) {
        return this.m_type.isSubtypeOf(type.m_type);
    }

    public static void verifySubtype(ObjectType baseType, ObjectType extendedType) {
        if (!extendedType.isSubtypeOf(baseType)) {
            throw new PersistenceException("The object type '" + extendedType.getQualifiedName() + "' is not a subtype of the object type '" + baseType.getQualifiedName() + "'");
        }
    }

    public static void verifySubtype(String baseType, String extendedType) {
        ObjectType.verifySubtype(MetadataRoot.getMetadataRoot().getObjectType(baseType), MetadataRoot.getMetadataRoot().getObjectType(extendedType));
    }

    public static void verifySubtype(String baseType, ObjectType extendedType) {
        ObjectType baseObjectType = MetadataRoot.getMetadataRoot().getObjectType(baseType);
        Assert.assertTrue(baseObjectType != null, "Could not find the ObjectType for the base type.  The base type was: " + baseType + ".");
        ObjectType.verifySubtype(baseObjectType, extendedType);
    }

    public static void verifySubtype(ObjectType baseType, String extendedType) {
        ObjectType.verifySubtype(baseType, MetadataRoot.getMetadataRoot().getObjectType(extendedType));
    }
}

