/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate;

import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.util.Assert;
import com.arsdigita.util.ResourceManager;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Utilities {
    public static String getUniqueBaseString() {
        return "_" + new Date().getTime() / 1000L + "_";
    }

    public static String getBaseString(String sSeed) {
        if (sSeed == null || sSeed.length() == 0) {
            return Utilities.getUniqueBaseString();
        }
        return "_" + sSeed + "_";
    }

    public static File getBinaryFile() {
        ResourceManager rm = ResourceManager.getInstance();
        String sWebAppRoot = rm.getWebappRoot().getAbsolutePath();
        String sImgPath = sWebAppRoot + File.separator + "assets" + File.separator + "rhlogo.gif";
        File imgFile = new File(sImgPath);
        return imgFile;
    }

    public static String makeText(int iIndex) {
        StringBuffer sb = new StringBuffer(5000);
        for (int i = 0; i < 20; ++i) {
            sb.append(iIndex + " All work and no play makes Jack a dull boy.  ");
        }
        return sb.toString();
    }

    public static String makeTextBody() {
        return Utilities.makeText(0);
    }

    public static User getAdminUser() {
        UserCollection uc = User.retrieveAll();
        uc.filter(KernelHelper.getSystemAdministratorEmailAddress());
        uc.next();
        User sysadmin = uc.getUser();
        Assert.assertNotNull(sysadmin);
        uc.close();
        return sysadmin;
    }

    public static List getUsersIDs(int numUsers) {
        UserCollection users = User.retrieveAll();
        users.setRange(new Integer(1), new Integer(numUsers + 1));
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(numUsers);
        while (users.next()) {
            list.add(users.getUser().getID());
        }
        users.close();
        return list;
    }
}

