/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.apps;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.populate.apps.PopulateAppPair;
import com.arsdigita.populate.apps.PopulateAppPairCollection;
import com.arsdigita.portal.Portal;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PopulateApps {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$populate$apps$PopulateApps == null ? (class$com$arsdigita$populate$apps$PopulateApps = PopulateApps.class$("com.arsdigita.populate.apps.PopulateApps")) : class$com$arsdigita$populate$apps$PopulateApps));
    private PopulateAppPairCollection m_PopAppPairs;
    private String m_sBaseStringSeed;
    static /* synthetic */ Class class$com$arsdigita$populate$apps$PopulateApps;

    public PopulateApps(PopulateAppPairCollection popAppPairs) {
        this.m_PopAppPairs = popAppPairs;
    }

    public void setBaseStringSeed(String sSeed) {
        this.m_sBaseStringSeed = sSeed;
    }

    public String getBaseStringSeed() {
        return this.m_sBaseStringSeed;
    }

    public List populate(int iNumApps, Application appParent, Portal portal) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        String sBaseString = Utilities.getBaseString(this.m_sBaseStringSeed);
        int iSize = this.m_PopAppPairs.getSize();
        int iTotalSize = iNumApps * iSize;
        s_log.info((Object)("Creating " + iNumApps + " instaces of " + iSize + " applications for a total of " + iTotalSize + " apps"));
        ArrayList<BigDecimal> apps = new ArrayList<BigDecimal>(iTotalSize);
        for (int i = 0; i < iSize; ++i) {
            PopulateAppPair popAppPair = this.m_PopAppPairs.getPopulateApp(i);
            PopulateApp popApp = popAppPair.getPopulateApp();
            List args = popAppPair.getArgs();
            popApp.setBaseStringSeed(this.m_sBaseStringSeed);
            for (int j = 0; j < iNumApps; ++j) {
                String sTitle = popApp.getAppType().getTitle().replace(' ', '_') + sBaseString + j;
                s_log.info((Object)("Creating app " + sTitle + " with args " + args));
                popApp.createApp(sTitle, appParent);
                popApp.populateApp(args);
                apps.add(popApp.getApp().getID());
                if (portal == null) continue;
                txn.beginTxn();
                portal = Portal.retrieve(portal.getOID());
                portal.addPortlet(popApp.getPortlet(), 1);
                portal.save();
                txn.commitTxn();
            }
        }
        return apps;
    }

    public List populate(int iNumApps, Application parent) {
        return this.populate(iNumApps, parent, null);
    }

    public List populate(int iNumApps, Portal parent) {
        return this.populate(iNumApps, null, parent);
    }

    public List populate(int iNumApps) {
        return this.populate(iNumApps, null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

