/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.portal.PortletType;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class PortletSetup {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/PortletSetup.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected String m_profile;
    protected String m_key = null;
    protected String m_typeName = null;
    protected Category m_category;
    protected String m_title = null;
    protected String m_description = null;
    protected ApplicationType m_provider;
    protected String m_stylesheet = null;
    protected DomainObjectInstantiator m_instantiator = null;

    public PortletSetup(Category category) {
        this.m_category = category;
    }

    public void setPortletObjectType(String portletObjectType) {
        this.m_typeName = portletObjectType;
    }

    public void setProfile(String profile) {
        this.m_profile = profile;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setStylesheet(String stylesheet) {
        this.m_stylesheet = stylesheet;
    }

    public void setInstantiator(DomainObjectInstantiator instantiator) {
        this.m_instantiator = instantiator;
    }

    public void setProviderApplicationType(ApplicationType provider) {
        this.m_provider = provider;
    }

    public void setProviderApplicationType(String applicationObjectType) {
        ApplicationType provider = ApplicationType.retrieveApplicationTypeForApplication(applicationObjectType);
        Assert.assertNotNull(provider, "provider");
        this.setProviderApplicationType(provider);
    }

    protected void notice(String message) {
        this.m_category.info((Object)("PortletType '" + this.m_title + "' - " + message));
    }

    public PortletType run() {
        this.notice("Validating setup...");
        List messages = this.validate();
        if (messages.size() > 0) {
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                this.m_category.error((Object)((String)iter.next()));
            }
            return null;
        }
        this.notice("Done validating.");
        PortletType portletType = this.process();
        if (portletType != null) {
            portletType.save();
        }
        return portletType;
    }

    protected List validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.m_title == null) {
            messages.add("Title is not set.");
        }
        if (this.m_typeName == null) {
            messages.add("PortletObjectType is not set.");
        }
        if (this.m_instantiator == null) {
            messages.add("Instantiator is not set.");
        }
        if (this.m_profile == null) {
            messages.add("Profile is not set.");
        }
        return messages;
    }

    protected PortletType process() {
        this.notice("Starting setup...");
        PortletType portletType = null;
        if (!ResourceType.isInstalled(this.m_typeName)) {
            this.notice("Not installed.  Installing now...");
            this.notice("Using the following properties to perform install.");
            this.notice("  PortletObjectType: " + this.m_typeName);
            this.notice("  Title: " + this.m_title);
            this.notice("  Description: " + this.m_description);
            this.notice("  Profile: " + this.m_profile);
            this.notice("  Instantiator: " + this.m_instantiator);
            this.notice("  ProviderApplicationType: " + this.m_provider);
            this.notice("  Key: " + this.m_key);
            this.notice("  StyleSheet: " + this.m_stylesheet);
            portletType = PortletType.createPortletType(this.m_title, this.m_profile, this.m_typeName);
            portletType.setDescription(this.m_description);
            if (this.m_provider != null) {
                portletType.setProviderApplicationType(this.m_provider);
            }
            this.notice("Done installing.");
        } else {
            portletType = PortletType.retrievePortletTypeForPortlet(this.m_typeName);
        }
        DomainObjectFactory.registerInstantiator(this.m_typeName, this.m_instantiator);
        this.notice("Done setting up.");
        return portletType;
    }
}

