/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal.apportlet;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.portal.PortletRenderer;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.URL;

public class AppPortlet
extends Portlet {
    protected AppPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public Application getParentApplication() {
        Application app = (Application)this.getParentResource();
        return app;
    }

    public void setParentApplication(Application app) {
        this.setParentResource(app);
    }

    public AppPortletType getAppPortletType() {
        DataObject dataObject = (DataObject)this.get("resourceType");
        dataObject.specialize("com.arsdigita.portal.PortletType");
        AppPortletType portletType = AppPortletType.retrieveAppPortletType(dataObject);
        Assert.assertNotNull(portletType);
        return portletType;
    }

    public String getZoomURL() {
        if (this.getAppPortletType().isPortalApplication()) {
            Application application = this.getParentApplication();
            if (application != null) {
                return URL.getDispatcherPath() + application.getPrimaryURL();
            }
            return null;
        }
        return null;
    }

    public PortletRenderer getPortletRenderer() {
        AbstractPortletRenderer portletRenderer = this.doGetPortletRenderer();
        portletRenderer.setTitle(this.getTitle());
        portletRenderer.setCellNumber(this.getCellNumber());
        portletRenderer.setSortKey(this.getSortKey());
        portletRenderer.setProfile(this.getProfile());
        String zoomURL = this.getZoomURL();
        if (zoomURL != null) {
            portletRenderer.setPortletAttribute("applicationLink", zoomURL);
        }
        return portletRenderer;
    }
}

