/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.converter;

import com.arsdigita.search.converter.BaseConverter;
import com.arsdigita.search.converter.ConversionException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelConverter
extends BaseConverter {
    static /* synthetic */ Class class$com$arsdigita$mimetypes$MimeType;

    protected String[] getFileExtensions() {
        String[] extensions = new String[]{"xls"};
        return extensions;
    }

    public String convertDocument(InputStream stream) throws ConversionException {
        try {
            POIFSFileSystem poifs = new POIFSFileSystem(stream);
            DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
            HSSFRequest req = new HSSFRequest();
            StringBuffer output = new StringBuffer();
            req.addListenerForAllRecords((HSSFListener)new ExcelEvent(output));
            HSSFEventFactory factory = new HSSFEventFactory();
            factory.processEvents(req, (InputStream)din);
            stream.close();
            din.close();
            return output.toString();
        }
        catch (IOException ioe) {
            throw new ConversionException(ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ExcelEvent
    implements HSSFListener {
        private SSTRecord sstrec;
        private Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mimetypes$MimeType == null ? (class$com$arsdigita$mimetypes$MimeType = ExcelConverter.class$("com.arsdigita.mimetypes.MimeType")) : class$com$arsdigita$mimetypes$MimeType));
        private StringBuffer m_output;

        public ExcelEvent(StringBuffer output) {
            this.m_output = output;
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 2057: {
                    if (!this.s_log.isDebugEnabled()) break;
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() == 5) {
                        this.s_log.debug((Object)"Encountered workbook");
                        break;
                    }
                    if (bof.getType() != 16) break;
                    this.s_log.debug((Object)"Encountered sheet reference");
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    this.m_output.append(" " + numrec.getValue());
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 253: {
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    this.m_output.append(" " + this.sstrec.getString(lrec.getSSTIndex()));
                }
            }
        }
    }
}

