/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.filters;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.filters.PermissionFilterType;

public class PermissionFilterSpecification
extends FilterSpecification {
    public static final String PARTY = "party";
    public static final String PRIVILEGE = "privilege";

    public PermissionFilterSpecification() {
        this(PermissionFilterSpecification.lookupPublic());
    }

    public PermissionFilterSpecification(Party party) {
        this(party, PrivilegeDescriptor.READ);
    }

    public PermissionFilterSpecification(Party party, PrivilegeDescriptor privilege) {
        super(new Object[]{PARTY, party, PRIVILEGE, privilege}, new PermissionFilterType());
    }

    public Party getParty() {
        return (Party)this.get(PARTY);
    }

    public PrivilegeDescriptor getPrivilege() {
        return (PrivilegeDescriptor)this.get(PRIVILEGE);
    }

    private static Party lookupPublic() {
        OID oid = new OID("com.arsdigita.kernel.Party", -200);
        return (Party)DomainObjectFactory.newInstance(oid);
    }
}

