/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.categorization.Category;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.CategoryFilterSpecification;
import com.arsdigita.search.filters.ObjectTypeFilterSpecification;
import com.arsdigita.search.filters.PermissionFilterSpecification;
import com.arsdigita.search.intermedia.DataQueryResultSet;
import com.arsdigita.search.intermedia.SearchDataQuery;
import com.arsdigita.search.intermedia.SimpleSearchSpecification;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseQueryEngine
extends LockableImpl
implements QueryEngine {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$intermedia$BaseQueryEngine == null ? (class$com$arsdigita$search$intermedia$BaseQueryEngine = BaseQueryEngine.class$("com.arsdigita.search.intermedia.BaseQueryEngine")) : class$com$arsdigita$search$intermedia$BaseQueryEngine));
    public static final String OBJECT_ID = "object_id";
    public static final String OBJECT_TYPE = "object_type";
    public static final String SUMMARY = "summary";
    public static final String LINK_TEXT = "link_text";
    public static final String LANGUAGE = "language";
    public static final String SCORE = "score";
    private Map m_columns = new HashMap();
    private Map m_tables = new HashMap();
    private List m_conditions = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$BaseQueryEngine;

    public BaseQueryEngine() {
        this.addColumn("c.object_id", OBJECT_ID);
        this.addColumn("c.object_type", OBJECT_TYPE);
        this.addColumn("c.link_text", LINK_TEXT);
        this.addColumn("c.summary", SUMMARY);
        this.addColumn("c.language", LANGUAGE);
        this.addColumn("((score(1) * " + Search.getConfig().getXMLContentWeight() + ") +" + " (score(2) * " + Search.getConfig().getRawContentWeight() + "))", SCORE);
        this.addTable("search_content", "c");
    }

    public ResultSet process(QuerySpecification spec) {
        String terms;
        if (!this.isLocked()) {
            this.lock();
        }
        if ((terms = this.cleanSearchString(spec.getTerms())) == null || "".equals(terms)) {
            return Search.EMPTY_RESULT_SET;
        }
        DataQuery q = this.buildQuery(terms, spec.allowPartialMatch());
        this.addFilters(q, spec.getFilters());
        return new DataQueryResultSet(q);
    }

    protected DataQuery buildQuery(String terms, boolean partial) {
        ArrayList props = new ArrayList();
        String query = this.buildQueryString(terms, partial, props);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running query {\n" + query + "}"));
        }
        Session session = SessionManager.getSession();
        SearchDataQuery q = new SearchDataQuery(session, query, props.toArray(new String[props.size()]));
        return q;
    }

    protected String buildQueryString(String terms, boolean partial, List props) {
        StringBuffer sb = new StringBuffer("select \n");
        Iterator columns = this.m_columns.keySet().iterator();
        while (columns.hasNext()) {
            String field = (String)columns.next();
            String alias = (String)this.m_columns.get(field);
            props.add(alias);
            sb.append("  " + field + " as " + alias);
            if (columns.hasNext()) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append("from \n");
        Iterator tables = this.m_tables.keySet().iterator();
        while (tables.hasNext()) {
            String name = (String)tables.next();
            String alias = (String)this.m_tables.get(name);
            sb.append("  " + name + " " + alias);
            if (tables.hasNext()) {
                sb.append(",\n");
                continue;
            }
            sb.append("\n");
        }
        sb.append("where\n");
        Iterator conditions = this.m_conditions.iterator();
        while (conditions.hasNext()) {
            sb.append("  " + (String)conditions.next() + " and\n");
        }
        sb.append("  " + SimpleSearchSpecification.containsClause("c", terms, "1", "2") + "\n");
        sb.append("order by score desc\n");
        return sb.toString();
    }

    protected void addColumn(String field, String propName) {
        Assert.unlocked(this);
        this.m_columns.put(field, propName);
    }

    protected void addTable(String table, String alias) {
        Assert.unlocked(this);
        this.m_tables.put(table, alias);
    }

    protected void addCondition(String condition) {
        Assert.unlocked(this);
        this.m_conditions.add(condition);
    }

    protected String cleanSearchString(String terms) {
        return SimpleSearchSpecification.cleanSearchString(terms, " and ");
    }

    protected void addFilters(DataQuery query, FilterSpecification[] filters) {
        Assert.locked(this);
        for (int i = 0; i < filters.length; ++i) {
            this.addFilter(query, filters[i]);
        }
    }

    protected void addFilter(DataQuery query, FilterSpecification filter) {
        Assert.locked(this);
        FilterType type = filter.getType();
        if ("permission".equals(type.getKey())) {
            this.addPermissionFilter(query, (PermissionFilterSpecification)filter);
        } else if ("objectType".equals(type.getKey())) {
            this.addObjectTypeFilter(query, (ObjectTypeFilterSpecification)filter);
        } else if ("category".equals(type.getKey())) {
            this.addCategoryFilter(query, (CategoryFilterSpecification)filter);
        }
    }

    protected void addPermissionFilter(DataQuery query, PermissionFilterSpecification filter) {
        Assert.locked(this);
        PermissionService.filterQuery(query, OBJECT_ID, filter.getPrivilege(), filter.getParty().getOID());
    }

    protected void addObjectTypeFilter(DataQuery query, ObjectTypeFilterSpecification filter) {
        Assert.locked(this);
        ArrayList<String> l = new ArrayList<String>();
        ObjectType[] types = filter.getTypes();
        if (types == null || types.length == 0) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            ObjectType type = types[i];
            l.add(type.getQualifiedName());
        }
        if (filter.isExclusion()) {
            Filter f = query.addFilter("object_type not in :types");
            f.set("types", l);
        } else {
            Filter f = query.addFilter("object_type in :types");
            f.set("types", l);
        }
    }

    protected void addCategoryFilter(DataQuery query, CategoryFilterSpecification filter) {
        Assert.locked(this);
        Category[] categories = filter.getCategories();
        if (categories != null && categories.length > 0) {
            ArrayList<BigDecimal> ids = new ArrayList<BigDecimal>();
            for (int i = 0; i < categories.length; ++i) {
                ids.add(categories[i].getID());
            }
            Filter f = query.addInSubqueryFilter(OBJECT_ID, "id", "com.arsdigita.search.categoryObjects");
            f.set("ids", ids);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

