/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.log4j.Logger;

class SearchContent
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SearchContent.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.search.intermedia.SearchContent";
    private static final byte[] EMTPY_CONTENT = new byte[0];
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$search$intermedia$SearchContent == null ? (class$com$arsdigita$search$intermedia$SearchContent = SearchContent.class$("com.arsdigita.search.intermedia.SearchContent")) : class$com$arsdigita$search$intermedia$SearchContent).getName());
    private static final String retrieveQuery = "com.arsdigita.search.intermedia.searchContentForObject";
    private static final String OBJECT_ID = "id";
    private static final String OBJECT_TYPE = "object_type";
    private static final String SUMMARY = "summary";
    private static final String LINK_TEXT = "link_text";
    private static final String URL_STUB = "url_stub";
    private static final String RAW_CONTENT = "raw_content";
    private static final String XML_CONTENT = "xml_content";
    private static final String LANGUAGE = "language";
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$SearchContent;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchContent retrieveForObject(OID oid) {
        DataQuery query = SessionManager.getSession().retrieveQuery(retrieveQuery);
        try {
            Filter f = query.addFilter("id=:id");
            f.set(OBJECT_ID, oid.get(OBJECT_ID));
            if (!query.next()) {
                SearchContent searchContent = null;
                return searchContent;
            }
            SearchContent searchContent = new SearchContent(new OID(BASE_DATA_OBJECT_TYPE, query.get(OBJECT_ID)));
            return searchContent;
        }
        finally {
            query.close();
        }
    }

    public SearchContent() throws DataObjectNotFoundException {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public SearchContent(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public void setObjectId(BigDecimal id) {
        this.set(OBJECT_ID, id);
    }

    public void setContentObjectType(String object_type) {
        this.set(OBJECT_TYPE, object_type);
    }

    public void setSummary(String summary) {
        this.set(SUMMARY, summary);
    }

    public void setLinkText(String linktext) {
        this.set(LINK_TEXT, linktext);
    }

    public void setUrlStub(String urlstub) {
        this.set(URL_STUB, urlstub);
    }

    public void setXMLContent(String xmlContent) {
        this.set(XML_CONTENT, xmlContent);
    }

    public void setRawContent(byte[] rawcontent) {
        this.set(RAW_CONTENT, rawcontent);
    }

    public void setLanguage(String language) {
        this.set(LANGUAGE, language);
    }

    public BigDecimal getObjectId() {
        return (BigDecimal)this.get(OBJECT_ID);
    }

    public String getContentObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public String getSummary() {
        return (String)this.get(SUMMARY);
    }

    public String getLinkText() {
        return (String)this.get(LINK_TEXT);
    }

    public String getUrlStub() {
        return (String)this.get(URL_STUB);
    }

    public String getXMLContent() {
        Object obj = this.get(XML_CONTENT);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Clob) {
            try {
                Clob clob = (Clob)obj;
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException sqle) {
                throw new UncheckedWrapperException("SQLE: " + sqle.getMessage(), sqle);
            }
        }
        throw new RuntimeException("Bad getClob datatype" + obj.getClass());
    }

    public byte[] getRawContent() {
        Object obj = this.get(RAW_CONTENT);
        if (obj == null) {
            return EMTPY_CONTENT;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof Blob) {
            try {
                Blob blob = (Blob)obj;
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException sqle) {
                throw new UncheckedWrapperException("SQL Error retieving raw content!", sqle);
            }
        }
        throw new RuntimeException("Bad getBlob datatype" + obj.getClass());
    }

    public String getLanguage() {
        return (String)this.get(LANGUAGE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

