/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.search.lucene.Document;
import com.arsdigita.search.lucene.Index;
import com.arsdigita.search.lucene.LuceneLock;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

class Indexer
extends TimerTask {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/Indexer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$Indexer == null ? (class$com$arsdigita$search$lucene$Indexer = Indexer.class$("com.arsdigita.search.lucene.Indexer")) : class$com$arsdigita$search$lucene$Indexer));
    private static final RuntimeConfig CONF = RuntimeConfig.getConfig();
    private static final LuceneLock LOCK = LuceneLock.getInstance();
    private File m_index;
    static /* synthetic */ Class class$com$arsdigita$search$lucene$Indexer;

    public Indexer(String index) {
        this.m_index = new File(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Session ssn = SessionManager.getSession();
        TransactionContext txn = ssn.getTransactionContext();
        if (txn.inTxn()) {
            throw new IllegalStateException("The lucene indexer must be run from its own transaction.");
        }
        txn.beginTxn();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Lucene indexer running for '" + this.m_index + "'."));
            }
            try {
                this.sync();
            }
            catch (IOException ioe) {
                LOG.error((Object)"couldn't sync", (Throwable)ioe);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Lucene indexer finished running for '" + this.m_index + "'."));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected error occured in Lucene indexer.", t);
        }
        finally {
            txn.commitTxn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync() throws IOException {
        LOG.debug((Object)"syncing");
        Session ssn = SessionManager.getSession();
        DataCollection dc = ssn.retrieve("com.arsdigita.search.lucene.Document");
        Filter filter = dc.addInSubqueryFilter("id", "com.arsdigita.search.lucene.dirtyDocuments");
        filter.set("dirty", new Integer(1 << Index.getIndexID()));
        try {
            while (dc.next()) {
                Document doc = Document.retrieve(dc.getDataObject());
                this.delete(doc);
                if (doc.isDeleted()) {
                    doc.setDirty(false);
                    doc.save();
                    continue;
                }
                this.update(doc);
                doc.setDirty(false);
                doc.save();
            }
        }
        finally {
            dc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Document doc) throws IOException {
        LuceneLock luceneLock = LOCK;
        synchronized (luceneLock) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting document (" + doc.getID() + "): " + doc.getTitle()));
            }
            IndexReader ir = IndexReader.open((File)this.m_index);
            try {
                ir.delete(new Term("id", doc.getID().toString()));
            }
            finally {
                ir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Document doc) throws IOException {
        LuceneLock luceneLock = LOCK;
        synchronized (luceneLock) {
            IndexWriter iw = new IndexWriter(this.m_index, (Analyzer)new StandardAnalyzer(), false);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Indexing document (" + doc.getID() + "): " + doc.getTitle()));
                }
                iw.addDocument(this.getDocument(doc));
            }
            finally {
                iw.close();
            }
        }
    }

    private org.apache.lucene.document.Document getDocument(Document doc) {
        org.apache.lucene.document.Document result = new org.apache.lucene.document.Document();
        result.add(Field.Keyword((String)"id", (String)doc.getID().toString()));
        String language = "";
        String country = "";
        Locale locale = doc.getLocale();
        if (locale != null) {
            language = locale.getLanguage();
            country = locale.getCountry();
        }
        result.add(Field.Keyword((String)"language", (String)language));
        result.add(Field.Keyword((String)"country", (String)country));
        result.add(Field.Keyword((String)"type", (String)doc.getType()));
        result.add(Field.Keyword((String)"typeSpecificInfo", (String)Indexer.toString(doc.getTypeSpecificInfo())));
        result.add(Field.Keyword((String)"title", (String)doc.getTitle()));
        result.add(Field.Keyword((String)"summary", (String)Indexer.toString(doc.getSummary())));
        result.add(Field.Text((String)"content", (String)Indexer.toString(doc.getContent())));
        result.add(Field.Keyword((String)"creationDate", (String)Indexer.toString(doc.getCreationDate())));
        result.add(Field.Keyword((String)"creationParty", (String)Indexer.toString(doc.getCreationParty())));
        result.add(Field.Keyword((String)"lastModifiedDate", (String)Indexer.toString(doc.getLastModifiedDate())));
        result.add(Field.Keyword((String)"lastModifiedParty", (String)Indexer.toString(doc.getLastModifiedParty())));
        return result;
    }

    private static final String toString(Date date) {
        return date == null ? "" : DateField.dateToString((Date)date);
    }

    private static final String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

