/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.CategoryFilterSpecification;
import com.arsdigita.search.filters.CategoryFilterType;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.xml.Element;

public abstract class CategoryFilterWidget
extends FilterWidget {
    public CategoryFilterWidget() {
        super((FilterType)new CategoryFilterType(), new ArrayParameter(new OIDParameter("category")));
    }

    public FilterSpecification getFilter(PageState state) {
        OID[] oids = (OID[])this.getValue(state);
        if (oids == null) {
            oids = new OID[]{};
        }
        Category[] cats = new Category[oids.length];
        for (int i = 0; i < cats.length; ++i) {
            cats[i] = (Category)DomainObjectFactory.newInstance(oids[i]);
        }
        return new CategoryFilterSpecification(cats);
    }

    public abstract Category[] getCategories(PageState var1);

    public void generateBodyXML(PageState state, Element parent) {
        super.generateBodyXML(state, parent);
        OID[] oids = (OID[])this.getValue(state);
        Category[] cats = this.getCategories(state);
        for (int i = 0; i < cats.length; ++i) {
            Element type = Search.newElement("category");
            type.addAttribute("oid", cats[i].getOID().toString());
            type.addAttribute("title", cats[i].getName());
            type.addAttribute("description", cats[i].getDescription());
            if (oids != null) {
                for (int j = 0; j < oids.length; ++j) {
                    if (!oids[j].equals(cats[i].getOID())) continue;
                    type.addAttribute("isSelected", "1");
                    break;
                }
            }
            parent.addContent(type);
        }
    }
}

