/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.search.ui.filters.DateRange;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;

public class DateRangeParameter
extends ParameterModel {
    static /* synthetic */ Class class$com$arsdigita$search$ui$filters$DateRange;

    public DateRangeParameter(String name) {
        super(name);
    }

    protected Calendar getCalendar(HttpServletRequest request) {
        return new GregorianCalendar();
    }

    public Object transformValue(HttpServletRequest request) throws IllegalArgumentException {
        Date start = this.transformOneDate(request, "start");
        Date end = this.transformOneDate(request, "end");
        if (start == null || end == null) {
            return this.transformSingleValue(request);
        }
        return new DateRange(start, end);
    }

    protected Date transformOneDate(HttpServletRequest request, String prefix) throws IllegalArgumentException {
        Calendar c = null;
        Date outVal = null;
        try {
            c = this.getCalendar(request);
            c.clear();
            c.setLenient(false);
            String year = Globalization.decodeParameter(request, this.getName() + "." + prefix + ".year");
            String month = Globalization.decodeParameter(request, this.getName() + "." + prefix + ".month");
            String day = Globalization.decodeParameter(request, this.getName() + "." + prefix + ".day");
            if (year == null && month == null && day == null) {
                return null;
            }
            if (day == null || day.length() == 0) {
                return null;
            }
            if (year != null) {
                c.set(1, Integer.parseInt(year));
            }
            if (month != null) {
                c.set(2, Integer.parseInt(month));
            }
            if (day != null) {
                c.set(5, Integer.parseInt(day));
            }
            outVal = c.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Day of Month");
        }
        return outVal;
    }

    public Object unmarshal(String encoded) {
        try {
            return new DateRange(encoded);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unmarshal date '" + encoded + "': " + e.getMessage());
        }
    }

    public Class getValueClass() {
        return class$com$arsdigita$search$ui$filters$DateRange == null ? (class$com$arsdigita$search$ui$filters$DateRange = DateRangeParameter.class$("com.arsdigita.search.ui.filters.DateRange")) : class$com$arsdigita$search$ui$filters$DateRange;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

