/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.ObjectTypeFilterSpecification;
import com.arsdigita.search.filters.ObjectTypeFilterType;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.xml.Element;

public class ObjectTypeFilterWidget
extends FilterWidget {
    private ObjectType[] m_types;

    public ObjectTypeFilterWidget(ObjectType[] types) {
        super((FilterType)new ObjectTypeFilterType(), new ArrayParameter(new StringParameter("objectType")));
        this.m_types = types;
    }

    public FilterSpecification getFilter(PageState state) {
        String[] types = (String[])this.getValue(state);
        if (types == null) {
            types = new String[]{};
        }
        return new ObjectTypeFilterSpecification(types);
    }

    public void generateBodyXML(PageState state, Element parent) {
        super.generateBodyXML(state, parent);
        String[] types = (String[])this.getValue(state);
        for (int i = 0; i < this.m_types.length; ++i) {
            Element type = Search.newElement("objectType");
            type.addAttribute("name", this.m_types[i].getQualifiedName());
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equals(this.m_types[i].getQualifiedName())) continue;
                type.addAttribute("isSelected", "1");
                break;
            }
            parent.addContent(type);
        }
    }
}

