/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CharacterReferenceEntities {
    private static final String LINE_END = System.getProperty("line.separator");
    private Map m_names = new HashMap();
    private List m_orderedNames = new ArrayList();

    CharacterReferenceEntities() {
    }

    public String getDecimalReference(String character) {
        CharacterReferenceEntity refEnt = (CharacterReferenceEntity)this.m_names.get(character);
        return refEnt == null ? null : refEnt.getDecimalReference();
    }

    public String getName(String character) {
        CharacterReferenceEntity refEnt = (CharacterReferenceEntity)this.m_names.get(character);
        return refEnt == null ? null : refEnt.getName();
    }

    public String getEntityDeclaration(String character) {
        CharacterReferenceEntity refEnt = (CharacterReferenceEntity)this.m_names.get(character);
        return refEnt == null ? null : refEnt.getEntityDeclaration();
    }

    public String getAllEntityDeclarations() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.m_orderedNames.iterator();
        while (i.hasNext()) {
            sb.append(this.getEntityDeclaration((String)i.next()));
            sb.append(LINE_END);
        }
        return sb.toString();
    }

    protected String registerEntity(String name, String decimalReference) {
        CharacterReferenceEntity entity = new CharacterReferenceEntity(name, decimalReference);
        this.m_names.put(entity.toString(), entity);
        this.m_orderedNames.add(entity.toString());
        return entity.toString();
    }

    private static class CharacterReferenceEntity {
        private String m_character;
        private String m_decimalReference;
        private String m_entityName;
        private String m_entityDeclaration;

        public CharacterReferenceEntity(String name, String decimalReference) {
            this.m_entityName = name;
            this.m_decimalReference = decimalReference;
            this.m_character = "" + (char)Integer.parseInt(decimalReference.substring(2, decimalReference.length() - 1));
            StringBuffer sb = new StringBuffer();
            sb.append("<!ENTITY ").append(this.getName());
            sb.append(" \"").append(this.getDecimalReference());
            sb.append("\">");
            this.m_entityDeclaration = sb.toString();
        }

        public String getEntityDeclaration() {
            return this.m_entityDeclaration;
        }

        public String toString() {
            return this.m_character;
        }

        public String getDecimalReference() {
            return this.m_decimalReference;
        }

        public String getName() {
            return this.m_entityName;
        }
    }
}

