/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating.html;

import com.arsdigita.templating.html.AttributeMapImpl;
import com.arsdigita.templating.html.ContentHandler;
import com.arsdigita.templating.html.HTMLParser;
import com.arsdigita.templating.html.HTMLParserException;
import com.arsdigita.templating.html.HTMLlat1;
import com.arsdigita.templating.html.HTMLspec;
import com.arsdigita.templating.html.HTMLsym;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XHTMLParser
implements HTMLParser {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$html$XHTMLParser == null ? (class$com$arsdigita$templating$html$XHTMLParser = XHTMLParser.class$("com.arsdigita.templating.html.XHTMLParser")) : class$com$arsdigita$templating$html$XHTMLParser));
    private static final String ROOT_TAG = "root";
    private static final String OPENING_ROOT_TAG = "<root>";
    private static final String CLOSING_ROOT_TAG = "</root>";
    private static final String LINE_END = System.getProperty("line.separator");
    private static final Set s_emptyTags = new HashSet();
    private final Set m_tags = new HashSet();
    private SAXParser m_saxParser;
    static /* synthetic */ Class class$com$arsdigita$templating$html$XHTMLParser;

    public XHTMLParser() throws HTMLParserException {
        try {
            this.m_saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new HTMLParserException("The underlying SAX parser can't be configured.", ex);
        }
        catch (SAXException ex) {
            throw new HTMLParserException("Error instantiating a SAX parser", ex);
        }
    }

    public void registerTag(String qName) {
        this.m_tags.add(qName);
    }

    public boolean isRegistered(String qName) {
        return this.m_tags.contains(qName);
    }

    public void parse(String html, ContentHandler handler) throws HTMLParserException {
        StringBuffer wellFormedHTML = new StringBuffer();
        wellFormedHTML.append("<!DOCTYPE html [").append(LINE_END);
        wellFormedHTML.append(HTMLlat1.getAllEntityDeclarations());
        wellFormedHTML.append(HTMLsym.getAllEntityDeclarations());
        wellFormedHTML.append(HTMLspec.getAllEntityDeclarations());
        wellFormedHTML.append(LINE_END).append("]>").append(LINE_END);
        wellFormedHTML.append(OPENING_ROOT_TAG).append(html).append(CLOSING_ROOT_TAG);
        char[] chars = new char[wellFormedHTML.length()];
        wellFormedHTML.getChars(0, wellFormedHTML.length(), chars, 0);
        CharArrayReader input = new CharArrayReader(chars);
        try {
            this.m_saxParser.parse(new InputSource(input), (DefaultHandler)new SAXDefaultHandler(handler, this));
        }
        catch (SAXException ex) {
            throw new HTMLParserException(ex);
        }
        catch (IOException ex) {
            throw new HTMLParserException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_emptyTags.add("br");
        s_emptyTags.add("hr");
    }

    private static class SAXDefaultHandler
    extends DefaultHandler {
        private HTMLParser m_parser;
        private ContentHandler m_handler;
        private StringBuffer m_buffer;

        public SAXDefaultHandler(ContentHandler htmlHandler, HTMLParser parser) {
            this.m_handler = htmlHandler;
            this.m_parser = parser;
            this.m_buffer = new StringBuffer();
        }

        public void startDocument() throws SAXException {
            try {
                this.m_handler.startDocument();
            }
            catch (HTMLParserException ex) {
                throw new SAXException(ex);
            }
        }

        public void endDocument() throws SAXException {
            try {
                if (this.m_buffer.length() > 0) {
                    this.m_handler.text(this.m_buffer.toString());
                }
                this.m_buffer = new StringBuffer();
                this.m_handler.endDocument();
            }
            catch (HTMLParserException ex) {
                throw new SAXException(ex);
            }
        }

        public void characters(char[] ch, int start, int len) {
            for (int i = 0; i < len; ++i) {
                this.m_buffer.append(ch[start + i]);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (XHTMLParser.ROOT_TAG.equals(qName)) {
                return;
            }
            if (!this.m_parser.isRegistered(qName)) {
                this.m_buffer.append("<").append(qName);
                for (int ii = 0; ii < attributes.getLength(); ++ii) {
                    this.m_buffer.append(" ").append(attributes.getQName(ii));
                    this.m_buffer.append("=\"");
                    this.m_buffer.append(attributes.getValue(ii)).append("\"");
                }
                if (s_emptyTags.contains(qName.toLowerCase())) {
                    this.m_buffer.append("/");
                }
                this.m_buffer.append(">");
                return;
            }
            try {
                this.m_handler.text(this.m_buffer.toString());
                this.m_buffer = new StringBuffer();
                this.m_handler.startElement(qName, new AttributeMapImpl(attributes));
            }
            catch (HTMLParserException ex) {
                throw new SAXException(ex);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (XHTMLParser.ROOT_TAG.equals(qName)) {
                return;
            }
            if (!this.m_parser.isRegistered(qName)) {
                if (!s_emptyTags.contains(qName.toLowerCase())) {
                    this.m_buffer.append("</").append(qName).append(">");
                }
                return;
            }
            try {
                if (this.m_buffer.length() > 0) {
                    this.m_handler.text(this.m_buffer.toString());
                    this.m_buffer = new StringBuffer();
                }
                this.m_handler.endElement(qName);
            }
            catch (HTMLParserException ex) {
                throw new SAXException(ex);
            }
        }
    }
}

